/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestIdentitiesDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardRequestIdentitiesDataStore
implements IRequestIdentitiesDataStore {
    private IToken<?> id;
    private final BiMap<IToken<?>, IRequest<?>> map;

    public StandardRequestIdentitiesDataStore(IToken<?> id, BiMap<IToken<?>, IRequest<?>> map) {
        this.id = id;
        this.map = map;
    }

    public StandardRequestIdentitiesDataStore() {
        this.id = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN);
        this.map = HashBiMap.create();
    }

    @Override
    public BiMap<IToken<?>, IRequest<?>> getIdentities() {
        return this.map;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardRequestIdentitiesDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardRequestIdentitiesDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardRequestIdentitiesDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardRequestIdentitiesDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardRequestIdentitiesDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequestIdentitiesDataStore standardRequestIdentitiesDataStore) {
            CompoundTag systemCompound = new CompoundTag();
            systemCompound.m_128365_("Token", (Tag)controller.serialize(standardRequestIdentitiesDataStore.getId()));
            systemCompound.m_128365_("List", (Tag)standardRequestIdentitiesDataStore.getIdentities().keySet().stream().map(token -> {
                CompoundTag mapCompound = new CompoundTag();
                mapCompound.m_128365_("Token", (Tag)controller.serialize(token));
                mapCompound.m_128365_("Request", (Tag)controller.serialize((IRequest)standardRequestIdentitiesDataStore.getIdentities().get(token)));
                return mapCompound;
            }).collect(NBTUtils.toListNBT()));
            return systemCompound;
        }

        @Override
        @NotNull
        public StandardRequestIdentitiesDataStore deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            IToken token = (IToken)controller.deserialize(nbt.m_128469_("Token"));
            ListTag list = nbt.m_128437_("List", 10);
            Map<IToken, IRequest> map = NBTUtils.streamCompound(list).map(tag -> {
                IToken id = (IToken)controller.deserialize(tag.m_128469_("Token"));
                IRequest request = (IRequest)controller.deserialize(tag.m_128469_("Request"));
                return new Tuple((Object)id, (Object)request);
            }).collect(Collectors.toMap(t -> (IToken)t.m_14418_(), t -> (IRequest)t.m_14419_()));
            HashBiMap biMap = HashBiMap.create(map);
            return new StandardRequestIdentitiesDataStore(token, (BiMap<IToken<?>, IRequest<?>>)biMap);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequestIdentitiesDataStore input, FriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.getIdentities().size());
            input.getIdentities().forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardRequestIdentitiesDataStore deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            IToken token = (IToken)controller.deserialize(buffer);
            HashMap<IToken, IRequest> identities = new HashMap<IToken, IRequest>();
            int assignmentsSize = buffer.readInt();
            for (int i = 0; i < assignmentsSize; ++i) {
                identities.put((IToken)controller.deserialize(buffer), (IRequest)controller.deserialize(buffer));
            }
            HashBiMap biMap = HashBiMap.create(identities);
            return new StandardRequestIdentitiesDataStore(token, (BiMap<IToken<?>, IRequest<?>>)biMap);
        }

        @Override
        public short getSerializationId() {
            return 32;
        }
    }
}

