/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.managers;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.util.Log;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EventDescriptionManager
implements IEventDescriptionManager {
    private static final String TAG_EVENT_DESC_LIST = "event_descs_list";
    private final IColony colony;
    private final LinkedList<IColonyEventDescription> eventDescs = new LinkedList();

    public EventDescriptionManager(IColony colony) {
        this.colony = colony;
    }

    @Override
    public void addEventDescription(IColonyEventDescription colonyEventDescription) {
        if (this.eventDescs.size() >= 100) {
            this.eventDescs.removeFirst();
        }
        this.eventDescs.add(colonyEventDescription);
        if (this.colony.getBuildingManager().getTownHall() != null) {
            this.colony.getBuildingManager().getTownHall().markDirty();
        } else {
            this.colony.markDirty();
        }
    }

    @Override
    public List<IColonyEventDescription> getEventDescriptions() {
        return this.eventDescs;
    }

    public void deserializeNBT(@NotNull CompoundTag eventManagerNBT) {
        ListTag eventDescListNBT = eventManagerNBT.m_128437_(TAG_EVENT_DESC_LIST, 10);
        for (Tag event : eventDescListNBT) {
            CompoundTag eventCompound = (CompoundTag)event;
            ResourceLocation eventTypeID = new ResourceLocation("minecolonies", eventCompound.m_128461_("name"));
            ColonyEventDescriptionTypeRegistryEntry registryEntry = (ColonyEventDescriptionTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventDescriptionRegistry().getValue(eventTypeID);
            if (registryEntry == null) {
                Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.m_135815_());
                continue;
            }
            IColonyEventDescription eventDescription = registryEntry.deserializeEventDescriptionFromNBT(eventCompound);
            this.eventDescs.add(eventDescription);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag eventManagerNBT = new CompoundTag();
        ListTag eventDescsListNBT = new ListTag();
        for (IColonyEventDescription event : this.eventDescs) {
            CompoundTag eventNBT = (CompoundTag)event.serializeNBT();
            eventNBT.m_128359_("name", event.getEventTypeId().m_135815_());
            eventDescsListNBT.add((Object)eventNBT);
        }
        eventManagerNBT.m_128365_(TAG_EVENT_DESC_LIST, (Tag)eventDescsListNBT);
        return eventManagerNBT;
    }
}

