/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.production.agriculture.EntityAIWorkFisherman;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import org.jetbrains.annotations.NotNull;

public class JobFisherman
extends AbstractJob<EntityAIWorkFisherman, JobFisherman> {
    private Tuple<BlockPos, BlockPos> water;
    @NotNull
    private ArrayList<Tuple<BlockPos, BlockPos>> ponds = new ArrayList();

    public JobFisherman(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.FISHERMAN_ID;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull CompoundTag waterTag = new CompoundTag();
        if (this.water != null) {
            BlockPosUtil.write(waterTag, "waterpond", this.water.getA());
            BlockPosUtil.write(waterTag, "parentpond", this.water.getB());
        }
        @NotNull ListTag lakes = new ListTag();
        for (Tuple<BlockPos, BlockPos> pond : this.ponds) {
            CompoundTag compoundNBT = new CompoundTag();
            BlockPosUtil.write(compoundNBT, "waterpond", pond.getA());
            BlockPosUtil.write(compoundNBT, "parentpond", pond.getB());
            lakes.add((Object)compoundNBT);
        }
        compound.m_128365_("newPonds", (Tag)lakes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("waterpond")) {
            this.water = new Tuple<BlockPos, BlockPos>(BlockPosUtil.read(compound, "waterpond"), BlockPosUtil.read(compound, "parentpond"));
        }
        this.ponds = new ArrayList();
        if (compound.m_128441_("newPonds")) {
            ListTag listOfPonds = compound.m_128437_("newPonds", 10);
            for (int i = 0; i < listOfPonds.size(); ++i) {
                this.ponds.add(new Tuple<BlockPos, BlockPos>(BlockPosUtil.read(listOfPonds.m_128728_(i), "waterpond"), BlockPosUtil.read(listOfPonds.m_128728_(i), "parentpond")));
            }
        }
    }

    @Override
    @NotNull
    public EntityAIWorkFisherman generateAI() {
        return new EntityAIWorkFisherman(this);
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
    }

    public Tuple<BlockPos, BlockPos> getWater() {
        return this.water;
    }

    public void setWater(Tuple<BlockPos, BlockPos> water) {
        this.water = water;
    }

    @NotNull
    public List<Tuple<BlockPos, BlockPos>> getPonds() {
        return new ArrayList<Tuple<BlockPos, BlockPos>>(this.ponds);
    }

    public void addToPonds(BlockPos pond, BlockPos parent) {
        this.ponds.add(new Tuple<BlockPos, BlockPos>(pond, parent));
    }

    public void removeFromPonds(Tuple<BlockPos, BlockPos> pond) {
        this.ponds.remove(pond);
    }
}

