/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.fields;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.fields.AbstractField;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PlantationField
extends AbstractField {
    private static final String TAG_WORKING_POS = "workingPositions";
    private List<BlockPos> workingPositions = new ArrayList<BlockPos>();

    public PlantationField(@NotNull FieldRegistries.FieldEntry fieldType, @NotNull BlockPos position) {
        super(fieldType, position);
    }

    public static PlantationField create(FieldRegistries.FieldEntry fieldEntry, BlockPos position) {
        return (PlantationField)fieldEntry.produceField(position);
    }

    @Override
    public boolean isValidPlacement(IColony colony) {
        BlockState blockState = colony.getWorld().m_8055_(this.getPosition());
        return blockState.m_60713_(ModBlocks.blockHutPlantation) || blockState.m_60713_(ModBlocks.blockPlantationField);
    }

    public List<BlockPos> getWorkingPositions() {
        return this.workingPositions.stream().toList();
    }

    public void setWorkingPositions(List<BlockPos> workingPositions) {
        this.workingPositions = workingPositions;
    }

    public IPlantationModule getModule() {
        return (IPlantationModule)this.getFirstModuleOccurance(IPlantationModule.class);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        BlockPosUtil.writePosListToNBT(compound, TAG_WORKING_POS, this.workingPositions);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag compound) {
        super.deserializeNBT(compound);
        this.workingPositions = BlockPosUtil.readPosListFromNBT(compound, TAG_WORKING_POS);
    }

    @Override
    public void serialize(@NotNull FriendlyByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.workingPositions.size());
        for (BlockPos workingPosition : this.workingPositions) {
            buf.m_130064_(workingPosition);
        }
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        super.deserialize(buf);
        this.workingPositions = new ArrayList<BlockPos>();
        int workingPositionCount = buf.readInt();
        for (int index = 0; index < workingPositionCount; ++index) {
            this.workingPositions.add(buf.m_130135_());
        }
    }
}

