/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.colonyEvents.raidEvents.pirateEvent;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.colonyEvents.raidEvents.AbstractShipRaidEvent;
import com.minecolonies.core.colony.colonyEvents.raidEvents.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public class DrownedPirateRaidEvent
extends AbstractShipRaidEvent {
    public static final ResourceLocation PIRATE_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "drowned_pirate_raid");
    public static final String SHIP_NAME = "sunk_ship";
    public static final int DEPTH_REQ = 13;

    public DrownedPirateRaidEvent(@NotNull IColony colony) {
        super(colony);
    }

    @Override
    public String getShipDesc() {
        return SHIP_NAME;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        this.status = EventStatus.PREPARING;
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint")), this.colony.getWorld(), blueprint -> {
            blueprint.rotateWithMirror(BlockPosUtil.getRotationFromRotations(this.shipRotation), Mirror.NONE, this.colony.getWorld());
            if (this.spawnPathResult != null && this.spawnPathResult.isDone()) {
                BlockPos endpoint;
                Path path = this.spawnPathResult.getPath();
                if (path != null && path.m_77403_() && ShipBasedRaiderUtils.canPlaceShipAt(endpoint = path.m_77395_().m_77288_().m_7495_(), blueprint, this.colony.getWorld(), 13)) {
                    this.spawnPoint = endpoint;
                }
                this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 30);
            }
            if (!ShipBasedRaiderUtils.canPlaceShipAt(this.spawnPoint, blueprint, this.colony.getWorld(), 13)) {
                this.spawnPoint = this.spawnPoint.m_7495_();
            }
            while (PathfindingUtils.isLiquid(this.colony.getWorld().m_8055_(this.spawnPoint))) {
                this.spawnPoint = this.spawnPoint.m_7495_();
            }
            if (!ShipBasedRaiderUtils.spawnPirateShip(this.spawnPoint, this.colony, blueprint, this)) {
                this.status = EventStatus.CANCELED;
                return;
            }
            this.updateRaidBar();
            MessageUtils.format("event.minecolonies.raidmessage_p" + this.shipSize.messageID, new Object[]{BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint), this.colony.getName()}).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
            this.colony.markDirty();
        }));
    }

    public static IColonyEvent loadFromNBT(@NotNull IColony colony, @NotNull CompoundTag compound) {
        DrownedPirateRaidEvent raidEvent = new DrownedPirateRaidEvent(colony);
        raidEvent.deserializeNBT(compound);
        return raidEvent;
    }

    @Override
    public boolean isUnderWater() {
        return true;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.DROWNED_PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.DROWNED_ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.DROWNED_CHIEFPIRATE;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.raid.pirate.name");
    }
}

