/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.AbstractPlantationModule;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UpwardsGrowingPlantModule
extends AbstractPlantationModule {
    protected static final int DEFAULT_MINIMUM_PLANT_LENGTH = 3;
    private final Random random = new Random();

    protected UpwardsGrowingPlantModule(IField field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workingPosition) {
        IPlantationModule.ActionToPerform action = this.decideWorkAction(world, workingPosition, false);
        return switch (action) {
            case IPlantationModule.ActionToPerform.HARVEST -> new IPlantationModule.PlantationModuleResult.Builder().harvest(workingPosition.m_6630_(2)).pickNewPosition();
            case IPlantationModule.ActionToPerform.PLANT -> new IPlantationModule.PlantationModuleResult.Builder().plant(workingPosition.m_7494_()).pickNewPosition();
            case IPlantationModule.ActionToPerform.CLEAR -> new IPlantationModule.PlantationModuleResult.Builder().clear(workingPosition.m_7494_()).pickNewPosition();
            default -> IPlantationModule.PlantationModuleResult.NONE;
        };
    }

    private IPlantationModule.ActionToPerform decideWorkAction(Level world, BlockPos plantingPosition, boolean enablePercentChance) {
        BlockState blockState = world.m_8055_(plantingPosition.m_7494_());
        if (this.isValidPlantingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.PLANT;
        }
        if (this.isValidClearingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.CLEAR;
        }
        if (this.canHarvest(world, plantingPosition, enablePercentChance)) {
            return IPlantationModule.ActionToPerform.HARVEST;
        }
        return IPlantationModule.ActionToPerform.NONE;
    }

    protected boolean isValidPlantingBlock(BlockState blockState) {
        return blockState.m_60795_();
    }

    protected boolean isValidClearingBlock(BlockState blockState) {
        return !this.isValidHarvestBlock(blockState);
    }

    private boolean canHarvest(Level world, BlockPos plantingPosition, boolean enablePercentChance) {
        int minimumPlantLength = this.getMinimumPlantLength();
        Integer maximumPlantLength = this.getMaximumPlantLength();
        if (maximumPlantLength != null && enablePercentChance) {
            BlockState blockState;
            float currentHeight = 0.0f;
            for (int height = minimumPlantLength; height <= maximumPlantLength && this.isValidHarvestBlock(blockState = world.m_8055_(plantingPosition.m_6630_(height))); ++height) {
                currentHeight = height;
            }
            float chance = currentHeight / (float)maximumPlantLength.intValue();
            return this.random.nextFloat() < chance;
        }
        BlockState blockAtMinHeight = world.m_8055_(plantingPosition.m_6630_(minimumPlantLength));
        return this.isValidHarvestBlock(blockAtMinHeight);
    }

    protected abstract boolean isValidHarvestBlock(BlockState var1);

    protected int getMinimumPlantLength() {
        return 3;
    }

    @Nullable
    protected Integer getMaximumPlantLength() {
        return null;
    }

    @Override
    public BlockPos getNextWorkingPosition(Level world) {
        for (BlockPos position : this.getWorkingPositions()) {
            if (this.decideWorkAction(world, position, true) == IPlantationModule.ActionToPerform.NONE) continue;
            return position;
        }
        return null;
    }

    @Override
    public int getActionLimit() {
        return 10;
    }

    @Override
    public List<ItemStack> getRequiredItemsForOperation() {
        return List.of(new ItemStack((ItemLike)this.getItem()));
    }

    @Override
    public BlockPos getPositionToWalkTo(Level world, BlockPos workingPosition) {
        return Stream.of(workingPosition.m_122012_(), workingPosition.m_122019_(), workingPosition.m_122024_(), workingPosition.m_122029_()).filter(pos -> world.m_8055_(pos).m_60795_()).findFirst().orElse(workingPosition);
    }
}

