/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation;

import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.fields.PlantationField;
import com.minecolonies.core.colony.fields.modules.AbstractFieldModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPlantationModule
extends AbstractFieldModule
implements IPlantationModule {
    protected static final int DEFAULT_MAX_PLANTS = 20;
    private final String fieldTag;
    private final String workTag;
    private final Item item;

    protected AbstractPlantationModule(IField field, String fieldTag, String workTag, Item item) {
        super(field);
        this.fieldTag = fieldTag;
        this.workTag = workTag;
        this.item = item;
    }

    @Override
    public final String getFieldTag() {
        return this.fieldTag;
    }

    @Override
    public final String getWorkTag() {
        return this.workTag;
    }

    @Override
    public final Item getItem() {
        return this.item;
    }

    @Override
    public int getPlantsToRequest() {
        return (int)Math.ceil((double)new ItemStack((ItemLike)this.item).m_41741_() / 4.0);
    }

    @Override
    public ResourceLocation getRequiredResearchEffect() {
        return null;
    }

    @Override
    public List<BlockPos> getValidWorkingPositions(@NotNull Level world, List<BlockPos> workingPositions) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        int maxWorkingPositions = this.getMaxWorkingPositions();
        for (int i = 0; i < maxWorkingPositions && workingPositions.size() != i; ++i) {
            result.add(workingPositions.get(i));
        }
        return result;
    }

    protected int getMaxWorkingPositions() {
        return 20;
    }

    @Override
    public List<Item> getValidBonemeal() {
        return List.of();
    }

    @Override
    public BlockPos getPositionToWalkTo(Level world, BlockPos workingPosition) {
        return workingPosition;
    }

    @Override
    public BlockState getPlantingBlockState(Level world, BlockPos workPosition, BlockState blockState) {
        return blockState;
    }

    @Override
    public void applyBonemeal(AbstractEntityCitizen worker, BlockPos workPosition, ItemStack stackInSlot, Player fakePlayer) {
        BoneMealItem.applyBonemeal((ItemStack)stackInSlot, (Level)worker.m_9236_(), (BlockPos)workPosition, (Player)fakePlayer);
        BoneMealItem.m_40638_((LevelAccessor)worker.m_9236_(), (BlockPos)workPosition, (int)1);
    }

    protected final List<BlockPos> getWorkingPositions() {
        IField iField = this.field;
        if (iField instanceof PlantationField) {
            PlantationField plantationField = (PlantationField)iField;
            return plantationField.getWorkingPositions();
        }
        return new ArrayList<BlockPos>();
    }

    @Override
    public int hashCode() {
        return this.fieldTag.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPlantationModule that = (AbstractPlantationModule)o;
        return this.fieldTag.equals(that.fieldTag);
    }
}

