/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesNamedGrave;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.tileentities.TileEntityGrave;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingGraveyard
extends AbstractBuilding {
    private static final String GRAVEYARD = "graveyard";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_VISUAL_GRAVES = "visualgraves";
    private static final String TAG_VISUAL_GRAVES_BLOCKPOS = "visualgravesblockpos";
    private static final String TAG_VISUAL_GRAVES_FACING = "visualgravesfacing";
    private static final String TAG_CURRENT_GRAVE = "currentGRAVE";
    @Nullable
    private BlockPos currentGrave;
    private Set<com.minecolonies.api.util.Tuple<BlockPos, Direction>> visualGravePositions = new HashSet<com.minecolonies.api.util.Tuple<BlockPos, Direction>>();

    public BuildingGraveyard(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.m_41720_() == Items.f_42747_, new Tuple((Object)2, (Object)true));
    }

    public void ClearCurrentGrave() {
        this.currentGrave = null;
    }

    @Nullable
    public BlockPos getGraveToWorkOn() {
        if (this.currentGrave != null) {
            BlockEntity tileEntity;
            if (WorldUtil.isBlockLoaded((LevelAccessor)this.colony.getWorld(), this.currentGrave) && (tileEntity = this.getColony().getWorld().m_7702_(this.currentGrave)) instanceof TileEntityGrave) {
                return this.currentGrave;
            }
            this.colony.getGraveManager().unReserveGrave(this.currentGrave);
            this.currentGrave = null;
        }
        this.currentGrave = this.colony.getGraveManager().reserveNextFreeGrave();
        return this.currentGrave;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_(TAG_CURRENT_GRAVE)) {
            this.currentGrave = BlockPosUtil.read(compound, TAG_CURRENT_GRAVE);
        }
        this.visualGravePositions.clear();
        ListTag visualGraveTagList = compound.m_128437_(TAG_VISUAL_GRAVES, 10);
        for (int i = 0; i < visualGraveTagList.size(); ++i) {
            CompoundTag graveCompound = visualGraveTagList.m_128728_(i);
            BlockPos graveLocation = BlockPosUtil.read(graveCompound, TAG_VISUAL_GRAVES_BLOCKPOS);
            Direction graveFacing = Direction.m_122402_((String)graveCompound.m_128461_(TAG_VISUAL_GRAVES_FACING));
            this.visualGravePositions.add(new com.minecolonies.api.util.Tuple<BlockPos, Direction>(graveLocation, graveFacing));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.currentGrave != null) {
            BlockPosUtil.write(compound, TAG_CURRENT_GRAVE, this.currentGrave);
        }
        @NotNull ListTag visualGraveTagList = new ListTag();
        for (com.minecolonies.api.util.Tuple<BlockPos, Direction> vgp : this.visualGravePositions) {
            @NotNull CompoundTag graveCompound = new CompoundTag();
            BlockPosUtil.write(graveCompound, TAG_VISUAL_GRAVES_BLOCKPOS, vgp.getA());
            graveCompound.m_128359_(TAG_VISUAL_GRAVES_FACING, vgp.getB().m_122433_());
            visualGraveTagList.add((Object)graveCompound);
        }
        compound.m_128365_(TAG_VISUAL_GRAVES, (Tag)visualGraveTagList);
        return compound;
    }

    public Set<com.minecolonies.api.util.Tuple<BlockPos, Direction>> getGravePositions() {
        return this.visualGravePositions;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return GRAVEYARD;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState state, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(state, pos, world);
        if (state.m_60734_() == ModBlocks.blockNamedGrave) {
            this.visualGravePositions.add(new com.minecolonies.api.util.Tuple<BlockPos, Direction>(pos, (Direction)state.m_61143_((Property)AbstractBlockMinecoloniesNamedGrave.FACING)));
        }
    }

    public com.minecolonies.api.util.Tuple<BlockPos, Direction> getRandomFreeVisualGravePos() {
        if (this.visualGravePositions.isEmpty()) {
            return null;
        }
        ArrayList<com.minecolonies.api.util.Tuple<BlockPos, Direction>> availablePos = new ArrayList<com.minecolonies.api.util.Tuple<BlockPos, Direction>>();
        for (com.minecolonies.api.util.Tuple<BlockPos, Direction> tuple : this.visualGravePositions) {
            if (!this.getColony().getWorld().m_8055_(tuple.getA()).m_247087_()) continue;
            availablePos.add(tuple);
        }
        if (availablePos.isEmpty()) {
            return null;
        }
        Collections.shuffle(availablePos);
        return (com.minecolonies.api.util.Tuple)availablePos.get(0);
    }
}

