/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.client.gui.modules.FarmFieldsModuleWindow;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.FieldsModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.moduleviews.FieldsModuleView;
import com.minecolonies.core.colony.fields.FarmField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> FERTILIZE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "fertilize"));
    private static final String FARMER = "farmer";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingFarmer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.HOE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (FieldsModule module : this.getModulesByType(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                FarmField farmField;
                if (!(field instanceof FarmField) || (farmField = (FarmField)field).getSeed().m_41619_()) continue;
                toKeep.put(stack -> ItemStack.m_41656_((ItemStack)farmField.getSeed(), (ItemStack)stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
            }
        }
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (FieldsModule module : this.getModulesByType(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                FarmField farmField;
                if (!(field instanceof FarmField) || (farmField = (FarmField)field).getSeed().m_41619_() || !ItemStackUtils.compareItemStacksIgnoreStackSize(farmField.getSeed(), stack).booleanValue()) continue;
                return false;
            }
        }
        if (stack.m_41720_() == Items.f_42405_) {
            return false;
        }
        return super.canEat(stack);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    public boolean requestFertilizer() {
        return this.getSetting(FERTILIZE).getValue();
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_FARMER).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_FARMER).orElse(false);
        }
    }

    public static class FarmerFieldsModuleView
    extends FieldsModuleView {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BOWindow getWindow() {
            return new FarmFieldsModuleWindow(this.buildingView, this);
        }

        @Override
        public boolean canAssignFieldOverride(IField field) {
            FarmField farmField;
            return field instanceof FarmField && !(farmField = (FarmField)field).getSeed().m_41619_();
        }

        @Override
        protected List<IField> getFieldsInColony() {
            return this.getColony().getFields(field -> field.getFieldType().equals(FieldRegistries.farmField.get()));
        }

        @Override
        @Nullable
        public MutableComponent getFieldWarningTooltip(IField field) {
            FarmField farmField;
            MutableComponent result = super.getFieldWarningTooltip(field);
            if (result != null) {
                return result;
            }
            if (field instanceof FarmField && (farmField = (FarmField)field).getSeed().m_41619_()) {
                return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.fields.farmer.noseed");
            }
            return null;
        }
    }

    public static class FarmerFieldsModule
    extends FieldsModule {
        @Override
        protected int getMaxFieldCount() {
            return this.building.getBuildingLevel();
        }

        @Override
        public Class<?> getExpectedFieldType() {
            return FarmField.class;
        }

        @Override
        @NotNull
        public List<IField> getFields() {
            return this.building.getColony().getBuildingManager().getFields(field -> field.getFieldType().equals(FieldRegistries.farmField.get())).stream().toList();
        }

        @Override
        public boolean canAssignFieldOverride(IField field) {
            FarmField farmField;
            return field instanceof FarmField && !(farmField = (FarmField)field).getSeed().m_41619_();
        }

        @Override
        protected int getFieldCheckTimeoutSeconds() {
            return 60;
        }
    }
}

