/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingCook
extends AbstractBuilding {
    private static final String COOK_DESC = "cook";
    public static final String FOOD_EXCLUSION_LIST = "food";
    private static final int MAX_BUILDING_LEVEL = 5;
    private boolean isCooking = false;
    private int isCookingTimeout = 0;
    private boolean initTags = false;
    private List<BlockPos> sitPositions;
    private int lastSitting = 0;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(this::isAllowedFood, new Tuple((Object)64, (Object)true));
        this.keepX.put(stack -> !ItemStackUtils.isEmpty(stack.getCraftingRemainingItem()) && !stack.getCraftingRemainingItem().m_41720_().equals(Items.f_42446_), new Tuple((Object)64, (Object)false));
    }

    public boolean isAllowedFood(ItemStack stack) {
        ItemListModule listModule = (ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals(FOOD_EXCLUSION_LIST));
        return ItemStackUtils.ISFOOD.test(stack) && !listModule.isItemInList(new ItemStorage(stack)) && !listModule.isItemInList(new ItemStorage(MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack)));
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        this.sitPositions = this.getLocationsFromTag("sit");
        this.initTags = !this.sitPositions.isEmpty();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.initTags = false;
    }

    public static void onResetFoodExclusionList(ItemListModule listModule) {
        listModule.clearItems();
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(ModTags.excludedFood)) {
            listModule.addItem(new ItemStorage(new ItemStack((ItemLike)item)));
        }
    }

    public BlockPos getNextSittingPosition() {
        this.initTagPositions();
        if (this.sitPositions.isEmpty()) {
            return null;
        }
        ++this.lastSitting;
        if (this.lastSitting >= this.sitPositions.size()) {
            this.lastSitting = 0;
        }
        return this.sitPositions.get(this.lastSitting);
    }

    public boolean getIsCooking() {
        ICitizenData citizen = ((CraftingWorkerBuildingModule)this.getModuleMatching(CraftingWorkerBuildingModule.class, (T m) -> m.getJobEntry() == ModJobs.cookassistant.get())).getFirstCitizen();
        return citizen != null && this.isCooking && this.isCookingTimeout > 0;
    }

    public void setIsCooking(boolean cookingState) {
        this.isCooking = cookingState;
        if (cookingState) {
            this.isCookingTimeout = 75;
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public boolean canBeGathered() {
        return super.canBeGathered() && ((CraftingWorkerBuildingModule)this.getModuleMatching(CraftingWorkerBuildingModule.class, (T m) -> m.getJobEntry() == ModJobs.cookassistant.get())).getAssignedCitizen().stream().map(c -> c.getJob(AbstractJobCrafter.class)).filter(Objects::nonNull).allMatch(AbstractJobCrafter::hasTask);
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (inventory && ((MinimumStockModule)this.getFirstModuleOccurance(MinimumStockModule.class)).isStocked(stack)) {
            return stack.m_41613_();
        }
        if (jobEntry == ModJobs.cookassistant.get()) {
            return stack.m_41613_();
        }
        if (this.isAllowedFood(stack) && (localAlreadyKept.stream().filter(storage -> ItemStackUtils.ISFOOD.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        Predicate<ItemStack> allowedFuel = theStack -> ((ItemListModule)this.getModuleMatching(ItemListModule.class, (T m) -> m.getId().equals("fuel"))).isItemInList(new ItemStorage((ItemStack)theStack));
        if (allowedFuel.test(stack) && (localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory)) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        if (this.isCookingTimeout > 0) {
            --this.isCookingTimeout;
        }
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_COOK).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_COOK).orElse(ItemStackUtils.CAN_EAT.test(recipe.getPrimaryOutput()));
        }

        @Override
        @Nullable
        public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
            if (this.building.getBuildingLevel() < 3 || ((CraftingWorkerBuildingModule)this.building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getAssignedCitizen().isEmpty()) {
                return null;
            }
            IRecipeStorage storage = super.getFirstRecipe(stackPredicate);
            if (storage != null) {
                return storage;
            }
            storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate);
            if (storage != null && storage.getRecipeSource() != null && ItemStackUtils.ISFOOD.test(storage.getPrimaryOutput()) && this.isRecipeCompatible(GenericRecipe.of(storage))) {
                return storage;
            }
            return null;
        }

        @Override
        public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
            IRecipeStorage storage = super.getFirstFulfillableRecipe(stackPredicate, count, considerReservation);
            if (storage == null && (storage = FurnaceRecipes.getInstance().getFirstSmeltingRecipeByResult(stackPredicate)) != null) {
                HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
                for (ICitizenData workerEntity : ((CraftingWorkerBuildingModule)this.building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry)).getAssignedCitizen()) {
                    handlers.add(workerEntity.getInventory());
                }
                if (!storage.canFullFillRecipe(count, Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) {
                    return null;
                }
            }
            return storage;
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_COOK).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_COOK);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            ItemStack output = recipe.getPrimaryOutput();
            return ItemStackUtils.CAN_EAT.test(output) || ItemStackUtils.CAN_EAT.test(FurnaceRecipes.getInstance().getSmeltingResult(output));
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return this.building == null || this.building.getBuildingLevel() >= 3 ? super.getSupportedCraftingTypes() : ImmutableSet.of();
        }

        @Override
        public boolean isVisible() {
            return this.building.getBuildingLevel() >= 3;
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            if (this.building.getBuildingLevel() < 3) {
                return false;
            }
            return super.canRecipeBeAdded(token);
        }
    }
}

