/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingConcreteMixer
extends AbstractBuilding {
    private static final String CONCRETE_MIXER = "concretemixer";
    private static final int WATER_DEPTH_SUPPORT = 5;
    private final Map<Integer, List<BlockPos>> waterPos = new HashMap<Integer, List<BlockPos>>();
    private int minWaterLevel = 5;

    public BuildingConcreteMixer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        if (!blockState.m_60819_().m_76178_() && (blockState.m_60795_() || blockState.m_60734_() == Blocks.f_49990_) && blockState.m_60819_().m_76152_() == Fluids.f_76192_ && blockState.m_60819_().m_76186_() <= 5) {
            List fluidPos = this.waterPos.getOrDefault(blockState.m_60819_().m_76186_(), new ArrayList());
            if (!fluidPos.contains(pos)) {
                fluidPos.add(pos);
            }
            this.waterPos.put(blockState.m_60819_().m_76186_(), fluidPos);
            this.minWaterLevel = Math.min(this.minWaterLevel, blockState.m_60819_().m_76186_());
        }
        super.registerBlockPosition(blockState, pos, world);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        @NotNull ListTag waterMap = new ListTag();
        for (Map.Entry<Integer, List<BlockPos>> entry : this.waterPos.entrySet()) {
            CompoundTag waterCompound = new CompoundTag();
            waterCompound.m_128405_("level", entry.getKey().intValue());
            @NotNull ListTag waterList = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                waterList.add((Object)NbtUtils.m_129224_((BlockPos)pos));
            }
            waterCompound.m_128365_("Pond", (Tag)waterList);
            waterMap.add((Object)waterCompound);
        }
        compound.m_128365_("Pond", (Tag)waterMap);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.waterPos.clear();
        ListTag waterMapList = compound.m_128437_("Pond", 10);
        for (int i = 0; i < waterMapList.size(); ++i) {
            CompoundTag waterCompound = waterMapList.m_128728_(i);
            int level = waterCompound.m_128451_("level");
            this.minWaterLevel = Math.min(this.minWaterLevel, level);
            ListTag waterTagList = waterCompound.m_128437_("Pond", 10);
            ArrayList<BlockPos> water = new ArrayList<BlockPos>();
            for (int j = 0; j < waterTagList.size(); ++j) {
                CompoundTag waterSubCompound = waterTagList.m_128728_(j);
                BlockPos waterPos = NbtUtils.m_129239_((CompoundTag)waterSubCompound);
                if (water.contains(waterPos)) continue;
                water.add(waterPos);
            }
            this.waterPos.put(level, water);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CONCRETE_MIXER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Nullable
    public BlockPos getBlockToMine() {
        for (int i = 1; i <= this.minWaterLevel; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                if (!this.colony.getWorld().m_8055_(pos).m_204336_(ModTags.concreteBlocks)) continue;
                return pos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBlockToPlace() {
        for (int i = 1; i <= this.minWaterLevel; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                BlockState state = this.colony.getWorld().m_8055_(pos);
                if (state.m_60819_().m_76178_() || state.m_60734_() != Blocks.f_49990_) continue;
                return pos;
            }
        }
        return null;
    }

    public int outputBlockCountInWorld(ItemStack primaryOutput) {
        int count = 0;
        if (primaryOutput.m_41720_() instanceof BlockItem) {
            for (int i = 1; i <= this.minWaterLevel; ++i) {
                for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                    if (((BlockItem)primaryOutput.m_41720_()).m_40614_() != this.colony.getWorld().m_8055_(pos).m_60734_()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }
}

