/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.core.network.messages.server.colony.building.HireFireMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WorkerBuildingModuleView
extends AbstractBuildingModuleView
implements IAssignmentModuleView {
    private final Set<Integer> workerIDs = new HashSet<Integer>();
    private HiringMode hiringMode;
    private int maxInhabitants = 1;
    private Skill primary = Skill.Intelligence;
    private Skill secondary = Skill.Intelligence;
    private JobEntry jobEntry;

    @Override
    public List<Integer> getAssignedCitizens() {
        return new ArrayList<Integer>(this.workerIDs);
    }

    @Override
    public void addCitizen(@NotNull ICitizenDataView citizen) {
        this.workerIDs.add(citizen.getId());
        Network.getNetwork().sendToServer(new HireFireMessage(this.buildingView, true, citizen.getId(), this.getProducer().getRuntimeID()));
        citizen.setWorkBuilding(this.buildingView.getPosition());
        citizen.setJobView(this.getJobEntry().getJobViewProducer().get().apply(this.buildingView.getColony(), citizen));
        citizen.getJobView().setEntry(this.getJobEntry());
    }

    @Override
    public void removeCitizen(@NotNull ICitizenDataView citizen) {
        this.workerIDs.remove(citizen.getId());
        Network.getNetwork().sendToServer(new HireFireMessage(this.buildingView, false, citizen.getId(), this.getProducer().getRuntimeID()));
        citizen.setWorkBuilding(null);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.workerIDs.clear();
        for (int i = 0; i < size; ++i) {
            this.workerIDs.add(buf.readInt());
        }
        this.hiringMode = HiringMode.values()[buf.readInt()];
        this.maxInhabitants = buf.readInt();
        this.jobEntry = (JobEntry)buf.readRegistryIdSafe(JobEntry.class);
        this.primary = Skill.values()[buf.readInt()];
        this.secondary = Skill.values()[buf.readInt()];
    }

    @Override
    public String getIcon() {
        return "";
    }

    @Override
    public String getDesc() {
        return "";
    }

    @Override
    public boolean isPageVisible() {
        return false;
    }

    @NotNull
    public Skill getPrimarySkill() {
        return this.primary;
    }

    @NotNull
    public Skill getSecondarySkill() {
        return this.secondary;
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        Network.getNetwork().sendToServer(new BuildingHiringModeMessage(this.buildingView, hiringMode, this.getProducer().getRuntimeID()));
    }

    @Override
    public boolean canAssign(ICitizenDataView citizen) {
        return !citizen.isChild() && (citizen.getWorkBuilding() == null || this.workerIDs.contains(citizen.getId()) || this.buildingView.getColony().getBuilding(citizen.getWorkBuilding()) != null && this.buildingView.getColony().getBuilding(citizen.getWorkBuilding()).getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.canBeHiredAs(this.getJobEntry())) != null);
    }

    @Override
    public int getMaxInhabitants() {
        return this.maxInhabitants;
    }

    public String getJobDisplayName() {
        return Component.m_237115_((String)this.jobEntry.getTranslationKey()).getString();
    }

    @Override
    @NotNull
    public BOWindow getWindow() {
        return new WindowHutWorkerModulePlaceholder<IBuildingView>(this.buildingView);
    }

    @Override
    public JobEntry getJobEntry() {
        return this.jobEntry;
    }

    @Override
    public boolean isFull() {
        return !this.buildingView.allowsAssignment() || this.getAssignedCitizens().size() >= this.getMaxInhabitants();
    }
}

