/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.EntityIcon;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.network.messages.server.colony.citizen.RecallSingleCitizenMessage;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import org.jetbrains.annotations.NotNull;

public class WindowCitizenPage
extends AbstractWindowTownHall {
    private static final Comparator<ICitizenDataView> COMPARE_BY_NAME = Comparator.comparing(ICitizen::getName);
    @NotNull
    private final List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();
    private ICitizenDataView selectedCitizen;
    private Entity selectedEntity;
    private String filter = "";

    public WindowCitizenPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutcitizens.xml");
        this.updateCitizens();
        this.fillCitizensList();
        if (!this.citizens.isEmpty()) {
            this.selectedCitizen = this.citizens.get(0);
        }
        this.registerButton("name", this::citizenSelected);
        this.registerButton("recallone", this::recallOneClicked);
        this.fillCitizenInfo();
        this.fillHappinessList();
        ((TextField)this.window.findPaneOfTypeByID("search", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.updateCitizens();
            }
        });
    }

    private void updateCitizens() {
        this.citizens.clear();
        if (this.filter.isEmpty()) {
            this.citizens.addAll(((ITownHallView)this.building).getColony().getCitizens().values());
        } else {
            this.citizens.addAll(((ITownHallView)this.building).getColony().getCitizens().values().stream().filter(cit -> cit.getName().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || cit.getJobComponent().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))).toList());
        }
        this.citizens.sort(COMPARE_BY_NAME);
    }

    private void citizenSelected(Button button) {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        this.selectedCitizen = this.citizens.get(citizenList.getListElementIndexByPane((Pane)button));
        this.fillCitizenInfo();
    }

    private void fillCitizenInfo() {
        if (this.selectedCitizen == null) {
            return;
        }
        if (this.selectedCitizen.isFemale()) {
            ((Image)this.findPaneOfTypeByID("gender", Image.class)).setImage(new ResourceLocation("minecolonies:textures/gui/citizen/colonist_wax_female_smaller.png"), false);
        } else {
            ((Image)this.findPaneOfTypeByID("gender", Image.class)).setImage(new ResourceLocation("minecolonies:textures/gui/citizen/colonist_wax_male_smaller.png"), false);
        }
        ((Text)this.findPaneOfTypeByID("job", Text.class)).setText(this.selectedCitizen.getJobComponent().m_130940_(ChatFormatting.BOLD));
        ((Text)this.findPaneOfTypeByID("health", Text.class)).setText(Component.m_237113_((String)((int)this.selectedCitizen.getHealth() + "/" + (int)this.selectedCitizen.getMaxHealth())));
        ((Text)this.findPaneOfTypeByID("happinessLevel", Text.class)).setText(Component.m_237113_((String)((int)this.selectedCitizen.getHappiness() + "/10")));
        ((Text)this.findPaneOfTypeByID("saturation", Text.class)).setText(Component.m_237113_((String)((int)this.selectedCitizen.getSaturation() + "/20")));
        this.selectedEntity = Minecraft.m_91087_().f_91073_.m_6815_(this.selectedCitizen.getEntityId());
        if (this.selectedEntity != null && this.selectedEntity.m_20089_() == Pose.SLEEPING) {
            EntityIcon entityIcon = (EntityIcon)this.findPaneOfTypeByID("entity", EntityIcon.class);
            entityIcon.setEntity(this.selectedEntity);
            entityIcon.show();
        }
    }

    private void recallOneClicked(Button button) {
        if (this.selectedCitizen == null) {
            return;
        }
        Network.getNetwork().sendToServer(new RecallSingleCitizenMessage(this.building, this.selectedCitizen.getId()));
    }

    private void fillCitizensList() {
        ScrollingList citizenList = (ScrollingList)this.findPaneOfTypeByID("citizenList", ScrollingList.class);
        citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowCitizenPage.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ICitizenDataView citizen = WindowCitizenPage.this.citizens.get(index);
                Button button = (Button)rowPane.findPaneOfTypeByID("name", ButtonImage.class);
                button.setText(Component.m_237113_((String)citizen.getName()));
                AbstractTextBuilder.TextBuilder textBuilder = PaneBuilders.textBuilder();
                for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
                    String skillName = entry.getKey().name().toLowerCase(Locale.US);
                    int skillLevel = (Integer)entry.getValue().m_14418_();
                    textBuilder.append(Component.m_237115_((String)("com.minecolonies.coremod.gui.citizen.skills." + skillName)));
                    textBuilder.append(Component.m_237113_((String)(": " + skillLevel + " ")));
                }
                PaneBuilders.tooltipBuilder().hoverPane((Pane)button).build().setText(((Text)textBuilder.build()).getText());
                if (WindowCitizenPage.this.selectedCitizen == citizen) {
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
    }

    private void fillHappinessList() {
        HashMap<String, Double> happinessMap = new HashMap<String, Double>();
        for (ICitizenDataView data : ((ITownHallView)this.building).getColony().getCitizens().values()) {
            for (String modifier : data.getHappinessHandler().getModifiers()) {
                happinessMap.put(modifier, happinessMap.getOrDefault(modifier, 0.0) + data.getHappinessHandler().getModifier(modifier).getFactor(null));
            }
        }
        DecimalFormat df = new DecimalFormat("#.#");
        df.setRoundingMode(RoundingMode.CEILING);
        String roundedHappiness = df.format(((ITownHallView)this.building).getColony().getOverallHappiness());
        ((Text)this.findPaneOfTypeByID("happinessTitle", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.currenthappiness", (Object[])new Object[]{roundedHappiness}));
        final ArrayList happinessList = new ArrayList(happinessMap.entrySet());
        ScrollingList happinessScrollingList = (ScrollingList)this.findPaneOfTypeByID("happinessList", ScrollingList.class);
        happinessScrollingList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return happinessList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Map.Entry entry = (Map.Entry)happinessList.get(index);
                double value = (Double)entry.getValue() / (double)((ITownHallView)WindowCitizenPage.this.building).getColony().getCitizenCount();
                Image image = (Image)rowPane.findPaneOfTypeByID("icon", Image.class);
                Text label = (Text)rowPane.findPaneOfTypeByID("name", Text.class);
                label.setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness." + (String)entry.getKey())));
                if (value > 1.0) {
                    image.setImage(new ResourceLocation("minecolonies:textures/gui/happy_icon.png"), false);
                } else if (value == 1.0) {
                    image.setImage(new ResourceLocation("minecolonies:textures/gui/satisfied_icon.png"), false);
                } else if (value > 0.75) {
                    image.setImage(new ResourceLocation("minecolonies:textures/gui/unsatisfied_icon.png"), false);
                } else {
                    image.setImage(new ResourceLocation("minecolonies:textures/gui/unhappy_icon.png"), false);
                }
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)label).append(Component.m_237115_((String)("com.minecolonies.coremod.gui.townhall.happiness.desc." + (String)entry.getKey())))).build();
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateCitizens();
        EntityIcon entityIcon = (EntityIcon)this.findPaneOfTypeByID("entity", EntityIcon.class);
        if (this.selectedEntity != null && this.selectedEntity.m_20089_() == Pose.SLEEPING) {
            entityIcon.hide();
        } else {
            entityIcon.show();
        }
    }

    @Override
    protected String getWindowId() {
        return "citizens";
    }
}

