/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowSelectRes;
import com.minecolonies.core.network.messages.server.colony.building.AddMinimumStockToBuildingModuleMessage;
import com.minecolonies.core.network.messages.server.colony.building.RemoveMinimumStockFromBuildingModuleMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MinimumStockModuleWindow
extends AbstractModuleWindow {
    private static final String RESOURCE_STRING = ":gui/layouthuts/layoutminimumstock.xml";
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private final ScrollingList resourceList;
    private final IMinimumStockModuleView moduleView;

    public MinimumStockModuleWindow(IBuildingView building, IMinimumStockModuleView moduleView) {
        super(building, "minecolonies:gui/layouthuts/layoutminimumstock.xml");
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.moduleView = moduleView;
        this.registerButton("addStock", this::addStock);
        if (moduleView.hasReachedLimit()) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
            button.setText(Component.m_237115_((String)LABEL_LIMIT_REACHED));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_disabled.png"), false);
        }
        this.registerButton("removeStock", this::removeStock);
    }

    private void removeStock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        Tuple<ItemStorage, Integer> tuple = this.moduleView.getStock().get(row);
        this.moduleView.getStock().remove(row);
        Network.getNetwork().sendToServer(new RemoveMinimumStockFromBuildingModuleMessage(this.buildingView, tuple.getA().getItemStack(), this.moduleView.getProducer().getRuntimeID()));
        this.updateStockList();
    }

    private void addStock() {
        if (!this.moduleView.hasReachedLimit()) {
            new WindowSelectRes(this, stack -> true, (stack, qty) -> Network.getNetwork().sendToServer(new AddMinimumStockToBuildingModuleMessage(this.buildingView, (ItemStack)stack, (int)qty)), true).open();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return MinimumStockModuleWindow.this.moduleView.getStock().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = MinimumStockModuleWindow.this.moduleView.getStock().get(index).getA().getItemStack().m_41777_();
                resource.m_41764_(resource.m_41741_());
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.m_41786_());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(Component.m_237113_((String)String.valueOf(MinimumStockModuleWindow.this.moduleView.getStock().get(index).getB())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

