/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.containers;

import com.minecolonies.api.inventory.container.ContainerGrave;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowGrave
extends AbstractContainerScreen<ContainerGrave> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/generic_108.png");
    private static final String LOCATION = "textures/gui/gui%s.png";
    private static final int SLOTS_EACH_ROW = 9;
    private static final int TEXTURE_SIZE = 350;
    private static final int SLOT_OFFSET = 18;
    private static final int GOOD_SIZE = 8;
    private static final int SIZE_MULTIPLIER = 3;
    private static final int Y_OFFSET = 114;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int TEXTURE_OFFSET = 235;
    private static final int EXTRA_OFFSET = 56;
    private static final int EXTRA_HEIGHT = 50;
    private final IItemHandler inv;
    private final int inventoryRows;

    public WindowGrave(ContainerGrave container, Inventory playerInventory, Component iTextComponent) {
        super((AbstractContainerMenu)container, playerInventory, iTextComponent);
        this.inv = container.grave.getInventory();
        this.inventoryRows = this.inv.getSlots() / 9;
        this.f_97727_ = 114 + Math.min(9, this.inventoryRows) * 18;
        if (this.inventoryRows > 8) {
            this.f_97726_ += (this.inventoryRows - 9) * 10;
        }
    }

    protected void m_280003_(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        stack.m_280056_(this.f_96547_, this.f_96539_.getString(), 8, 6, 0x404040, false);
        stack.m_280056_(this.f_96547_, this.f_169604_.getString(), 8, this.f_97727_ - (this.inventoryRows > 6 ? 110 : 94), 0x404040, false);
    }

    protected void m_7286_(@NotNull GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation loc = WindowGrave.getCorrectTextureForSlots(this.inventoryRows);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.inventoryRows < 9) {
            stack.m_280163_(loc, i, j, 0.0f, 0.0f, this.f_97726_, this.inventoryRows * 18 + 18 - 1, 350, 350);
            stack.m_280163_(loc, i, j + this.inventoryRows * 18 + 18 - 1, 0.0f, 235.0f, this.f_97726_, 96, 350, 350);
        } else {
            int textureOffset = 179;
            stack.m_280163_(loc, i, j, 0.0f, 0.0f, this.f_97726_ * 3 / 2, this.inventoryRows * 18 + 18 - 1, 350, 350);
            stack.m_280163_(loc, i, j + Math.min(9, this.inventoryRows) * 18 + 18 - 1, 0.0f, 179.0f, this.f_97726_ * 3 / 2, 146, 350, 350);
        }
    }

    private static ResourceLocation getCorrectTextureForSlots(int inventoryRows) {
        if (inventoryRows <= 8) {
            return CHEST_GUI_TEXTURE;
        }
        return new ResourceLocation("minecolonies", String.format(LOCATION, Integer.toString(inventoryRows * 9)));
    }

    public void m_88315_(@NotNull GuiGraphics stack, int x, int y, float z) {
        this.m_280273_(stack);
        super.m_88315_(stack, x, y, z);
        this.m_280072_(stack, x, y);
    }
}

