/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.workers.util;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;

public class GuardGear
implements Predicate<ItemStack> {
    private final int minLevelRequired;
    private final int maxLevelRequired;
    private final int minArmorLevel;
    private final int maxArmorLevel;
    private final int minBuildingLevelRequired;
    private final int maxBuildingLevelRequired;
    private final EquipmentSlot type;
    private final IToolType itemNeeded;

    public GuardGear(IToolType item, EquipmentSlot type, int minArmorLevel, int maxArmorLevel, Tuple<Integer, Integer> citizenLevelRange, Tuple<Integer, Integer> buildingLevelRange) {
        this.type = type;
        this.itemNeeded = item;
        this.minLevelRequired = (Integer)citizenLevelRange.m_14418_();
        this.maxLevelRequired = (Integer)citizenLevelRange.m_14419_();
        this.minArmorLevel = minArmorLevel;
        this.maxArmorLevel = maxArmorLevel;
        this.minBuildingLevelRequired = (Integer)buildingLevelRange.m_14418_();
        this.maxBuildingLevelRequired = (Integer)buildingLevelRange.m_14419_();
    }

    public int getMinLevelRequired() {
        return this.minLevelRequired;
    }

    public int getMaxLevelRequired() {
        return this.maxLevelRequired;
    }

    public EquipmentSlot getType() {
        return this.type;
    }

    public int getMinArmorLevel() {
        return this.minArmorLevel;
    }

    public int getMaxArmorLevel() {
        return this.maxArmorLevel;
    }

    public IToolType getItemNeeded() {
        return this.itemNeeded;
    }

    public int getMinBuildingLevelRequired() {
        return this.minBuildingLevelRequired;
    }

    public int getMaxBuildingLevelRequired() {
        return this.maxBuildingLevelRequired;
    }

    @Override
    public boolean test(ItemStack stack) {
        return ItemStackUtils.hasToolLevel(stack, this.itemNeeded, this.minArmorLevel, this.maxArmorLevel) && stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == this.getType() || stack.m_41720_() instanceof SwordItem && this.getType() == EquipmentSlot.MAINHAND || stack.m_41720_() instanceof ShieldItem && this.getType() == EquipmentSlot.OFFHAND;
    }
}

