/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.factory.standard;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.ITypeOverrideHandler;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class TypeTokenFactory
implements IFactory<Class<?>, TypeToken<?>> {
    @Override
    @NotNull
    public TypeToken<? extends TypeToken<?>> getFactoryOutputType() {
        return TypeConstants.TYPETOKEN;
    }

    @Override
    @NotNull
    public TypeToken<? extends Class<?>> getFactoryInputType() {
        return TypeConstants.CLASS;
    }

    @Override
    @NotNull
    public TypeToken<?> getNewInstance(@NotNull IFactoryController factoryController, @NotNull Class<?> aClass, Object ... context) throws IllegalArgumentException {
        return TypeToken.of(aClass);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull TypeToken<?> typeToken) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Value", typeToken.getRawType().getName());
        return compound;
    }

    @Override
    @NotNull
    public TypeToken<?> deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
        try {
            return TypeToken.of(Class.forName(nbt.m_128461_("Value").replace("coremod", "core")));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create TypeToken", e);
        }
    }

    @Override
    public void serialize(IFactoryController controller, TypeToken<?> input, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(input.getRawType().getName());
    }

    @Override
    public TypeToken<?> deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
        try {
            return TypeToken.of(Class.forName(buffer.m_130136_(Short.MAX_VALUE).replace("coremod", "core")));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to create TypeToken", e);
        }
    }

    @Override
    public short getSerializationId() {
        return 31;
    }

    public static class TypeTokenSubTypeOverrideHandler
    implements ITypeOverrideHandler<TypeToken<?>> {
        @Override
        public boolean matches(TypeToken<?> inputType) {
            return ReflectionUtils.getSuperClasses(inputType).contains(TypeConstants.TYPETOKEN);
        }

        @Override
        public TypeToken<TypeToken<?>> getOutputType() {
            return TypeConstants.TYPETOKEN;
        }
    }
}

