/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.event;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.event.AbstractBuildingEvent;
import com.minecolonies.api.colony.workorders.WorkOrderType;

public final class BuildingConstructionEvent
extends AbstractBuildingEvent {
    private final EventType eventType;

    public BuildingConstructionEvent(IBuilding building, EventType eventType) {
        super(building);
        this.eventType = eventType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public static enum EventType {
        BUILT,
        UPGRADED,
        REPAIRED,
        REMOVED;


        public static EventType fromWorkOrderType(WorkOrderType workOrderType) {
            return switch (workOrderType) {
                default -> throw new IncompatibleClassChangeError();
                case WorkOrderType.BUILD -> BUILT;
                case WorkOrderType.UPGRADE -> UPGRADED;
                case WorkOrderType.REPAIR -> REPAIRED;
                case WorkOrderType.REMOVE -> REMOVED;
            };
        }
    }
}

