/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.screen;

import com.witchica.compactstorage.CompactStoragePlatform;
import com.witchica.compactstorage.common.inventory.BackpackInventory;
import com.witchica.compactstorage.common.inventory.BackpackInventoryHandlerFactory;
import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CompactChestScreenHandler
extends AbstractContainerMenu {
    private Container inventory;
    private Inventory playerInventory;
    public CompactStorageInventoryImpl blockEntity;
    public int inventoryWidth;
    public int inventoryHeight;
    private ItemStack backpack;
    private boolean isBackpackInOffhand;

    public CompactChestScreenHandler(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        super(CompactStoragePlatform.getCompactStorageScreenHandler(), syncId);
        int inventoryType = buf.readInt();
        this.playerInventory = playerInventory;
        if (inventoryType == 0) {
            BlockPos pos = buf.m_130135_();
            CompactStorageInventoryImpl inv = (CompactStorageInventoryImpl)playerInventory.f_35978_.m_9236_().m_7702_(pos);
            this.inventory = (Container)inv;
            this.inventoryWidth = inv.getInventoryWidth();
            this.inventoryHeight = inv.getInventoryHeight();
            this.blockEntity = inv;
            this.backpack = null;
        } else {
            InteractionHand hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            BackpackInventory backpackInventory = BackpackInventoryHandlerFactory.getBackpackInventory(playerInventory.f_35978_, hand);
            this.inventory = backpackInventory;
            this.inventoryWidth = backpackInventory.inventoryWidth;
            this.inventoryHeight = backpackInventory.inventoryHeight;
            this.backpack = playerInventory.f_35978_.m_21120_(hand);
            this.isBackpackInOffhand = hand == InteractionHand.OFF_HAND;
            this.blockEntity = null;
        }
        CompactChestScreenHandler.m_38869_((Container)this.inventory, (int)(this.inventoryWidth * this.inventoryHeight));
        this.inventory.m_5856_(playerInventory.f_35978_);
        this.setupSlots(true);
    }

    protected CompactChestScreenHandler(@Nullable MenuType<?> type, int syncId) {
        super(type, syncId);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.inventory.m_5785_(player);
    }

    public void setupSlots(boolean includeChestInventory) {
        int j;
        int i;
        this.f_38839_.clear();
        int chestInvHeight = this.inventoryHeight * 18;
        for (i = 0; i < this.inventoryHeight; ++i) {
            for (j = 0; j < this.inventoryWidth; ++j) {
                Slot slot = new Slot(this.inventory, i * this.inventoryWidth + j, 8 + j * 18, 18 + i * 18);
                this.m_38897_(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, i * 9 + j + 9, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 18 + i * 18 + chestInvHeight + 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            if (this.blockEntity == null && j == this.playerInventory.f_35977_ && !this.isBackpackInOffhand) {
                this.m_38897_(new Slot((Container)this.playerInventory, j, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 18 + chestInvHeight + 60 + 18){

                    public boolean m_8010_(Player playerEntity) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)this.playerInventory, j, 8 + this.inventoryWidth * 18 / 2 - 81 + j * 18, 18 + chestInvHeight + 60 + 18));
        }
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int invSlot) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (invSlot < this.inventory.m_6643_() ? !this.m_38903_(originalStack, this.inventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, this.inventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }
}

