/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.inventory;

import com.witchica.compactstorage.common.util.CompactStorageInventoryImpl;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BackpackInventory
implements Container,
CompactStorageInventoryImpl {
    public NonNullList<ItemStack> items;
    public int inventoryWidth;
    public int inventoryHeight;
    private final Player player;
    private final int backpackSlot;
    private final boolean isInOffhand;

    public BackpackInventory(CompoundTag itemsNbt, Player player, boolean isInOffhand) {
        this.backpackSlot = player.m_150109_().f_35977_;
        this.player = player;
        this.isInOffhand = isInOffhand;
        this.fromTag(itemsNbt);
    }

    public void resizeInventory(boolean copy_contents) {
        NonNullList newInventory = NonNullList.m_122780_((int)(this.inventoryWidth * this.inventoryHeight), (Object)ItemStack.f_41583_);
        if (copy_contents) {
            NonNullList<ItemStack> list = this.items;
            for (int i = 0; i < list.size(); ++i) {
                newInventory.set(i, (Object)((ItemStack)list.get(i)));
            }
        }
        this.items = newInventory;
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public int getInventoryWidth() {
        return this.inventoryWidth;
    }

    @Override
    public int getInventoryHeight() {
        return this.inventoryHeight;
    }

    public int m_6643_() {
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void fromTag(CompoundTag tag) {
        this.inventoryWidth = tag.m_128441_("inventory_width") ? tag.m_128451_("inventory_width") : 9;
        this.inventoryHeight = tag.m_128441_("inventory_height") ? tag.m_128451_("inventory_height") : 6;
        this.items = NonNullList.m_122780_((int)(this.inventoryWidth * this.inventoryHeight), (Object)ItemStack.f_41583_);
        this.readItemsFromTag(this.items, tag);
    }

    public boolean increaseSize(int x, int y) {
        if (this.inventoryWidth > 23 && x > 0 || this.inventoryHeight > 11 && y > 0) {
            return false;
        }
        this.inventoryWidth += x;
        this.inventoryHeight += y;
        this.resizeInventory(true);
        this.m_6596_();
        return true;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("inventory_width", this.inventoryWidth);
        tag.m_128405_("inventory_height", this.inventoryHeight);
        this.writeItemsToTag(this.items, tag);
        return tag;
    }

    public void m_5856_(Player player) {
        super.m_5856_(player);
        player.m_6330_(SoundEvents.f_12639_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void m_5785_(Player player) {
        super.m_5785_(player);
        Inventory inventory = player.m_150109_();
        if (this.isInOffhand) {
            if (!player.m_21120_(InteractionHand.OFF_HAND).m_41782_()) {
                player.m_21120_(InteractionHand.OFF_HAND).m_41751_(new CompoundTag());
            }
            player.m_21120_(InteractionHand.OFF_HAND).m_41783_().m_128365_("Backpack", (Tag)this.toTag());
        } else {
            if (!inventory.m_8020_(this.backpackSlot).m_41782_()) {
                inventory.m_8020_(this.backpackSlot).m_41751_(new CompoundTag());
            }
            inventory.m_8020_(this.backpackSlot).m_41783_().m_128365_("Backpack", (Tag)this.toTag());
        }
        player.m_6330_(SoundEvents.f_12639_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

