/*
 * Decompiled with CFR 0.152.
 */
package com.witchica.compactstorage.common.block.entity;

import com.witchica.compactstorage.CompactStoragePlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DrumBlockEntity
extends BlockEntity {
    public ItemStack clientItem = ItemStack.f_41583_;
    public int clientStackSize;
    public int clientStoredItems;
    public final SimpleContainer inventory = new SimpleContainer(64){

        public int m_6893_() {
            if (this.m_8020_(0).m_41619_()) {
                return 64;
            }
            return this.m_8020_(0).m_41741_();
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return this.m_8020_(0).m_41619_() || ItemStack.m_41656_((ItemStack)this.m_8020_(0), (ItemStack)stack);
        }

        public void m_6596_() {
            super.m_6596_();
            DrumBlockEntity.this.m_6596_();
        }

        public ItemStack m_8016_(int slot) {
            for (int i = this.m_6643_() - 1; i >= 0; --i) {
                ItemStack stack = this.m_8020_(i);
                if (stack == null || stack.m_41619_()) continue;
                slot = i;
                break;
            }
            ItemStack stack = super.m_8016_(slot);
            this.m_6596_();
            return stack;
        }

        public ItemStack m_7407_(int slot, int amount) {
            for (int i = this.m_6643_() - 1; i >= 0; --i) {
                ItemStack stack = this.m_8020_(i);
                if (stack == null || stack.m_41619_()) continue;
                slot = i;
                break;
            }
            ItemStack stack = super.m_7407_(slot, amount);
            this.m_6596_();
            return stack;
        }
    };

    public DrumBlockEntity(BlockPos pos, BlockState state) {
        super(CompactStoragePlatform.getDrumBlockEntityType(), pos, state);
    }

    public boolean hasAnyItems() {
        return !this.inventory.m_8020_(0).m_41619_();
    }

    public Item getStoredType() {
        return this.hasAnyItems() ? this.inventory.m_8020_(0).m_41720_() : ItemStack.f_41583_.m_41720_();
    }

    public int getTotalItemCount() {
        return this.hasAnyItems() ? this.inventory.m_18947_(this.getStoredType()) : 0;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.inventory.m_7927_());
        nbt.m_128365_("ClientItem", (Tag)new ItemStack((ItemLike)this.getStoredType(), 1).m_41739_(new CompoundTag()));
        nbt.m_128405_("ClientStackSize", this.getStoredType().m_41459_());
        nbt.m_128405_("ClientStoredItems", this.getTotalItemCount());
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.m_7797_(nbt.m_128437_("Inventory", 10));
        this.clientItem = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ClientItem"));
        this.clientStackSize = nbt.m_128451_("ClientStackSize");
        this.clientStoredItems = nbt.m_128451_("ClientStoredItems");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public String getTextToDisplay() {
        int leftover;
        if (this.clientStackSize == 0) {
            return "Empty";
        }
        int numStacks = this.clientStoredItems / this.clientStackSize;
        if (numStacks == 0 & (leftover = this.clientStoredItems % this.clientStackSize) == 0) {
            return "Empty";
        }
        if (numStacks == 0) {
            return "" + leftover;
        }
        if (leftover == 0) {
            return this.clientStackSize + " x " + numStacks;
        }
        return this.clientStackSize + " x " + numStacks + " + " + leftover;
    }
}

