/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.Loggers;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedProperties;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class AllowedSoundConfig
extends CommentedPropertyConfig {
    private Map<String, Boolean> allowedSounds;

    public AllowedSoundConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
    }

    @Override
    public void load() throws IOException {
        super.load();
        this.allowedSounds = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            ResourceLocation resourceLocation;
            boolean value;
            String key = entry.getKey();
            try {
                value = Boolean.parseBoolean(entry.getValue());
            }
            catch (Exception e) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            try {
                resourceLocation = new ResourceLocation(key);
            }
            catch (Exception e) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            if (!resourceLocation.m_135827_().equals("voicechat")) {
                this.logIfUnknownSound(resourceLocation);
            }
            this.setAllowed(resourceLocation.toString(), value);
        }
        this.saveSync();
    }

    private void logIfUnknownSound(ResourceLocation resourceLocation) {
        try {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(resourceLocation);
            if (soundEvent == null) {
                Loggers.log("Unknown sound in allowed sound config: {}", resourceLocation);
            }
        }
        catch (Exception e) {
            Loggers.warn("Failed to parse allowed sound entry {}", resourceLocation, e);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.addHeaderComment("Allowed sounds");
        this.properties.addHeaderComment("Set to 'false' to disable sound physics for that sound");
        for (Map.Entry<String, Boolean> entry : this.allowedSounds.entrySet()) {
            this.properties.set(entry.getKey(), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<String, Boolean> getAllowedSounds() {
        return this.allowedSounds;
    }

    public boolean isAllowed(String soundEvent) {
        return this.allowedSounds.getOrDefault(soundEvent, true);
    }

    public AllowedSoundConfig setAllowed(String soundEvent, boolean allowed) {
        this.allowedSounds.put(soundEvent, allowed);
        return this;
    }

    public Map<String, Boolean> createDefaultMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (SoundEvent event : BuiltInRegistries.f_256894_) {
            map.put(event.m_11660_().toString(), true);
        }
        map.put(SoundEvents.f_12541_.m_11660_().toString(), false);
        map.put(SoundEvents.f_12542_.m_11660_().toString(), false);
        map.put(SoundEvents.f_12090_.m_11660_().toString(), false);
        SoundEvents.f_215702_.forEach(r -> map.put(r.m_205785_().m_135782_().toString(), false));
        return map;
    }
}

