/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public enum MobEffectProvider implements IEntityComponentProvider,
IDataProvider<LivingEntity>
{
    INSTANCE;

    public static final ResourceLocation DATA;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(Options.ATTRIBUTE_MOB_EFFECTS)) {
            return;
        }
        Data data = accessor.getData().get(Data.class);
        if (data == null) {
            return;
        }
        data.list.forEach(it -> {
            MutableComponent text = Component.m_237115_((String)it.m_19576_());
            int amplifier = it.m_19564_();
            if (amplifier > 0) {
                if (I18n.m_118936_((String)("potion.potency." + amplifier))) {
                    text = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{text, Component.m_237115_((String)("potion.potency." + amplifier))});
                } else {
                    text.m_130946_(" " + (amplifier + 1));
                }
            }
            if (it.m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                text.m_130940_(ChatFormatting.RED);
            }
            tooltip.addLine((Component)text);
        });
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<LivingEntity> accessor, IPluginConfig config) {
        if (config.getBoolean(Options.ATTRIBUTE_MOB_EFFECTS)) {
            data.add(Data.class, res -> res.add(new Data(((LivingEntity)accessor.getTarget()).m_21220_().stream().filter(it -> it.m_19572_() || config.getBoolean(Options.ATTRIBUTE_HIDDEN_MOB_EFFECTS)).toList())));
        }
    }

    static {
        DATA = new ResourceLocation("mob_effects");
    }

    public record Data(List<MobEffectInstance> list) implements IData
    {
        public Data(FriendlyByteBuf buf) {
            this(buf.m_236845_(b -> {
                MobEffect effect = (MobEffect)b.m_236816_((IdMap)BuiltInRegistries.f_256974_);
                int amplifier = b.m_130242_();
                return new MobEffectInstance(Objects.requireNonNull(effect), -1, amplifier);
            }));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_236828_(this.list, (b, m) -> {
                b.m_236818_((IdMap)BuiltInRegistries.f_256974_, (Object)m.m_19544_());
                b.m_130130_(m.m_19564_());
            });
        }
    }
}

