/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.mixin.BeaconBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.jetbrains.annotations.Nullable;

public enum BeaconProvider implements IBlockComponentProvider,
IDataProvider<BeaconBlockEntity>
{
    INSTANCE;

    public static final ResourceLocation DATA;

    private MutableComponent getText(MobEffect effect) {
        return effect.m_19482_().m_6881_();
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(Options.ATTRIBUTE_BEACON_EFFECTS)) {
            return;
        }
        Data data = accessor.getData().get(Data.class);
        if (data == null) {
            return;
        }
        if (data.primary != null) {
            MutableComponent text = this.getText(data.primary);
            if (data.primary == data.secondary) {
                text.m_130946_(" II");
            }
            tooltip.addLine((Component)text);
        }
        if (data.secondary != null && data.primary != data.secondary) {
            tooltip.addLine((Component)this.getText(data.secondary));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BeaconBlockEntity> accessor, IPluginConfig config) {
        if (config.getBoolean(Options.ATTRIBUTE_BEACON_EFFECTS)) {
            data.add(Data.class, res -> {
                BeaconBlockEntity beacon = (BeaconBlockEntity)((BeaconBlockEntityAccess)accessor.getTarget());
                res.add(new Data(((BeaconBlockEntityAccess)beacon).wthit_primaryPower(), ((BeaconBlockEntityAccess)beacon).wthit_levels() >= 4 ? ((BeaconBlockEntityAccess)beacon).wthit_secondaryPower() : null));
            });
        }
    }

    static {
        DATA = new ResourceLocation("beacon");
    }

    public record Data(@Nullable MobEffect primary, @Nullable MobEffect secondary) implements IData
    {
        public Data(FriendlyByteBuf buf) {
            this((MobEffect)buf.m_236868_(b -> (MobEffect)b.m_236816_((IdMap)BuiltInRegistries.f_256974_)), (MobEffect)buf.m_236868_(b -> (MobEffect)b.m_236816_((IdMap)BuiltInRegistries.f_256974_)));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_236821_((Object)this.primary, (b, m) -> b.m_236818_((IdMap)BuiltInRegistries.f_256974_, m));
            buf.m_236821_((Object)this.secondary, (b, m) -> b.m_236818_((IdMap)BuiltInRegistries.f_256974_, m));
        }
    }
}

