/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.plugin.extra.config.ExtraBlacklistConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DataProvider<A extends IData, I extends A>
implements IBlockComponentProvider,
IEntityComponentProvider {
    public static final Map<ResourceLocation, DataProvider<?, ?>> INSTANCES = new HashMap();
    private final ResourceLocation id;
    private final Class<A> apiType;
    private final Class<I> implType;
    private final IData.Serializer<I> serializer;
    protected final ResourceLocation enabledBlockOption;
    protected final ResourceLocation enabledEntityOption;
    protected final IJsonConfig<ExtraBlacklistConfig> blacklistConfig;

    protected DataProvider(ResourceLocation id, Class<A> apiType, Class<I> implType, IData.Serializer<I> serializer) {
        this.id = id;
        this.apiType = apiType;
        this.implType = implType;
        this.serializer = serializer;
        this.enabledBlockOption = this.createConfigKey("enabled_block");
        this.enabledEntityOption = this.createConfigKey("enabled_entity");
        ResourceLocation tagId = new ResourceLocation("waila", "extra/" + id.m_135815_() + "_blacklist");
        this.blacklistConfig = IJsonConfig.of(ExtraBlacklistConfig.class).file("waila/extra/" + id.m_135815_() + "_blacklist").gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ExtraBlacklistConfig.class, (Object)new ExtraBlacklistConfig.Adapter(tagId)).create()).build();
        this.blacklistConfig.save();
        INSTANCES.put(id, this);
    }

    public void register(IRegistrar registrar, int priority) {
        registrar.addFeatureConfig(this.enabledBlockOption, false);
        registrar.addFeatureConfig(this.enabledEntityOption, false);
        this.registerAdditions(registrar, priority);
        registrar.addConfig(this.createConfigKey("blacklist"), this.blacklistConfig.getPath());
        registrar.addDataType(this.id, this.apiType, this.implType, this.serializer);
        registrar.addComponent(this, TooltipPosition.BODY, BlockEntity.class, priority);
        registrar.addComponent(this, TooltipPosition.BODY, Entity.class, priority);
        registrar.addBlockData(new BlockDataProvider(), BlockEntity.class, 0);
        registrar.addEntityData(new EntityDataProvider(), Entity.class, 0);
    }

    protected final ResourceLocation createConfigKey(String path) {
        return new ResourceLocation("wailax", this.id.m_135815_() + "." + path);
    }

    protected void registerAdditions(IRegistrar registrar, int priority) {
    }

    protected abstract void appendBody(ITooltip var1, I var2, IPluginConfig var3, ResourceLocation var4);

    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, ResourceLocation objectId) {
        A data = reader.get(this.apiType);
        if (data == null) {
            return;
        }
        this.appendBody(tooltip, data, config, objectId);
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledBlockOption)) {
            return;
        }
        if (this.blacklistConfig.get().getView().blockFilter.matches(accessor.getBlock())) {
            return;
        }
        BlockEntityType blockEntityType = ((BlockEntity)Objects.requireNonNull(accessor.getBlockEntity())).m_58903_();
        if (this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
            return;
        }
        this.appendBody(tooltip, accessor.getData(), config, BuiltInRegistries.f_257049_.m_7981_((Object)blockEntityType));
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledEntityOption)) {
            return;
        }
        EntityType entityType = accessor.getEntity().m_6095_();
        if (this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
            return;
        }
        this.appendBody(tooltip, accessor.getData(), config, BuiltInRegistries.f_256780_.m_7981_((Object)entityType));
    }

    private class BlockDataProvider
    implements IDataProvider<BlockEntity> {
        private BlockDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
            BlockEntity target = accessor.getTarget();
            BlockState state = target.m_58900_();
            BlockEntityType blockEntityType = target.m_58903_();
            if (!config.getBoolean(DataProvider.this.enabledBlockOption) || DataProvider.this.blacklistConfig.get().getView().blockFilter.matches(state.m_60734_()) || DataProvider.this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
                data.blockAll(DataProvider.this.apiType);
            }
        }
    }

    private class EntityDataProvider
    implements IDataProvider<Entity> {
        private EntityDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<Entity> accessor, IPluginConfig config) {
            EntityType entityType = accessor.getTarget().m_6095_();
            if (!config.getBoolean(DataProvider.this.enabledEntityOption) || DataProvider.this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
                data.blockAll(DataProvider.this.apiType);
            }
        }
    }
}

