/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget
extends ContainerObjectSelectionList<Entry> {
    private final ConfigScreen owner;
    @Nullable
    private final Runnable diskWriter;
    private int topOffset;
    private int bottomOffset;
    @Nullable
    private EditBox searchBox;
    private List<Entry> unfilteredChildren;

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight, @Nullable Runnable diskWriter) {
        super(client, width, height, top, bottom, itemHeight - 4);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.resize(top, bottom);
        this.m_93488_(false);
    }

    public ConfigListWidget(ConfigScreen owner, Minecraft client, int width, int height, int top, int bottom, int itemHeight) {
        this(owner, client, width, height, top, bottom, itemHeight, null);
    }

    public int m_5759_() {
        return Math.min(this.f_93388_ - 20, 450);
    }

    protected int m_5756_() {
        return this.f_93386_.m_91268_().m_85445_() - 5;
    }

    public void tick() {
        if (this.searchBox != null) {
            this.searchBox.m_94120_();
        }
        this.m_6702_().forEach(Entry::tick);
    }

    public boolean save(boolean ignoreErrors) {
        List<ConfigValue> values = this.m_6702_().stream().filter(e -> e instanceof ConfigValue).map(e -> (ConfigValue)((Object)e)).toList();
        if (values.stream().allMatch(ConfigValue::isValueValid)) {
            values.forEach(ConfigValue::save);
            if (this.diskWriter != null) {
                this.diskWriter.run();
            }
            return true;
        }
        if (!ignoreErrors) {
            this.f_93386_.m_91300_().m_94922_((Toast)new SystemToast(SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)Component.m_237115_((String)"config.waila.invalid_input.title"), (Component)Component.m_237115_((String)"config.waila.invalid_input.desc")));
        }
        return ignoreErrors;
    }

    public EditBox getSearchBox() {
        if (this.searchBox != null) {
            return this.searchBox;
        }
        this.unfilteredChildren = new ArrayList<Entry>(this.m_6702_());
        String category = "";
        for (Entry child : this.unfilteredChildren) {
            if (child instanceof CategoryEntry) {
                category = child.category;
            }
            child.category = category;
        }
        this.searchBox = new EditBox(this.f_93386_.f_91062_, 0, 0, 160, 18, (Component)Component.m_237119_());
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"config.waila.search_prompt"));
        this.searchBox.m_94151_(filter -> {
            this.m_6702_().clear();
            if (filter.isBlank()) {
                this.m_6702_().addAll(this.unfilteredChildren);
            } else {
                this.m_6702_().addAll(this.unfilteredChildren.stream().filter(it -> it.match((String)filter)).toList());
            }
            this.init();
        });
        return this.searchBox;
    }

    public void init() {
        for (Entry child : this.m_6702_()) {
            child.m_7522_(null);
        }
        this.resize(this.topOffset, this.owner.f_96544_ + this.bottomOffset);
        this.m_93410_(this.m_93517_());
    }

    public void add(Entry entry) {
        this.add(this.m_6702_().size(), entry);
    }

    public void add(int index, Entry entry) {
        this.m_6702_().add(index, entry);
    }

    public ConfigListWidget with(Entry entry) {
        return this.with(this.m_6702_().size(), entry);
    }

    public ConfigListWidget with(int index, Entry entry) {
        this.add(index, entry);
        return this;
    }

    public void resize(int top, int bottom) {
        this.topOffset = top;
        this.bottomOffset = bottom - this.owner.f_96544_;
        this.m_93437_(this.owner.f_96543_, this.owner.f_96544_, this.topOffset, this.owner.f_96544_ + this.bottomOffset);
        if (this.searchBox != null) {
            this.searchBox.m_264152_(this.m_5747_() + this.m_5759_() - 160, (top - 18) / 2);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        protected final Minecraft client = Minecraft.m_91087_();
        @Nullable
        protected List<? extends GuiEventListener> children;
        @Nullable
        protected List<? extends NarratableEntry> narratables;
        public String category = "";

        public void tick() {
        }

        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        }

        protected void gatherNarratables(ImmutableList.Builder<NarratableEntry> narratables) {
        }

        protected boolean match(String filter) {
            return StringUtils.containsIgnoreCase((CharSequence)this.category, (CharSequence)filter);
        }

        @NotNull
        public List<? extends GuiEventListener> m_6702_() {
            if (this.children == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherChildren((ImmutableList.Builder<GuiEventListener>)builder);
                this.children = builder.build();
            }
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> m_142437_() {
            if (this.narratables == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherNarratables((ImmutableList.Builder<NarratableEntry>)builder);
                this.narratables = builder.build();
            }
            return this.narratables;
        }

        public void m_6311_(@NotNull GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (rowTop <= mouseY && mouseY < rowTop + height + 4) {
                ctx.m_280509_(0, rowTop - 2, this.client.m_91268_().m_85445_(), rowTop + height + 2, 0x22FFFFFF);
            }
        }
    }
}

