/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WailaConfig
implements IWailaConfig {
    private final General general = new General();
    private final Overlay overlay = new Overlay();
    private final Formatter formatter = new Formatter();
    private int configVersion = 0;

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Override
    public General getGeneral() {
        return this.general;
    }

    @Override
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    public static class General
    implements IWailaConfig.General {
        private boolean displayTooltip = true;
        private boolean shiftForDetails = false;
        private boolean hideShiftText = false;
        private IWailaConfig.General.DisplayMode displayMode = IWailaConfig.General.DisplayMode.TOGGLE;
        private boolean hideFromPlayerList = true;
        private boolean hideFromDebug = true;
        private boolean enableTextToSpeech = false;
        private int rateLimit = 250;

        @Override
        public boolean isDisplayTooltip() {
            return this.displayTooltip;
        }

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean isShiftForDetails() {
            return this.shiftForDetails;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        @Override
        public boolean isHideShiftText() {
            return this.hideShiftText;
        }

        public void setHideShiftText(boolean hideShiftText) {
            this.hideShiftText = hideShiftText;
        }

        @Override
        public IWailaConfig.General.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(IWailaConfig.General.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean isHideFromPlayerList() {
            return this.hideFromPlayerList;
        }

        public void setHideFromPlayerList(boolean hideFromPlayerList) {
            this.hideFromPlayerList = hideFromPlayerList;
        }

        @Override
        public boolean isHideFromDebug() {
            return this.hideFromDebug;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public boolean isEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        @Override
        public int getRateLimit() {
            this.rateLimit = Math.max(this.rateLimit, 250);
            return this.rateLimit;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }
    }

    public static class Overlay
    implements IWailaConfig.Overlay {
        private final Position position = new Position();
        private final Color color = new Color();
        private float scale = 1.0f;
        private int fps = 30;

        @Override
        public Position getPosition() {
            return this.position;
        }

        @Override
        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public int getFps() {
            return this.fps;
        }

        public void setFps(int fps) {
            this.fps = fps;
        }

        public static class Position
        implements IWailaConfig.Overlay.Position {
            private final Align align = new Align();
            private final Align anchor = new Align();
            private int x = 0;
            private int y = 0;
            private boolean bossBarsOverlap = false;

            @Override
            public int getX() {
                return this.x;
            }

            public void setX(int x) {
                this.x = x;
            }

            @Override
            public int getY() {
                return this.y;
            }

            public void setY(int y) {
                this.y = y;
            }

            @Override
            public Align getAlign() {
                return this.align;
            }

            @Override
            public Align getAnchor() {
                return this.anchor;
            }

            @Override
            public boolean isBossBarsOverlap() {
                return this.bossBarsOverlap;
            }

            public void setBossBarsOverlap(boolean bossBarsOverlap) {
                this.bossBarsOverlap = bossBarsOverlap;
            }

            public static class Align
            implements IWailaConfig.Overlay.Position.Align {
                IWailaConfig.Overlay.Position.Align.X x = IWailaConfig.Overlay.Position.Align.X.CENTER;
                IWailaConfig.Overlay.Position.Align.Y y = IWailaConfig.Overlay.Position.Align.Y.TOP;

                @Override
                public IWailaConfig.Overlay.Position.Align.X getX() {
                    return this.x;
                }

                public void setX(IWailaConfig.Overlay.Position.Align.X x) {
                    this.x = x;
                }

                @Override
                public IWailaConfig.Overlay.Position.Align.Y getY() {
                    return this.y;
                }

                public void setY(IWailaConfig.Overlay.Position.Align.Y y) {
                    this.y = y;
                }
            }
        }

        public static class Color
        implements IWailaConfig.Overlay.Color {
            private static final ResourceLocation DEFAULT = Waila.id("vanilla");
            private static boolean warnDeprecatedColorGetter = true;
            private int backgroundAlpha = 204;
            private ResourceLocation activeTheme = DEFAULT;
            private final Map<ResourceLocation, ThemeDefinition<?>> themes = new HashMap();

            private ThemeDefinition<?> getThemeDef() {
                Map<ResourceLocation, ThemeDefinition<?>> allTheme = ThemeDefinition.getAll();
                if (!allTheme.containsKey(this.activeTheme)) {
                    this.activeTheme = DEFAULT;
                    Waila.CONFIG.save();
                }
                return allTheme.get(this.activeTheme);
            }

            @Override
            public int getBackgroundAlpha() {
                return this.backgroundAlpha;
            }

            public void setBackgroundAlpha(int backgroundAlpha) {
                this.backgroundAlpha = backgroundAlpha;
            }

            @Override
            public ITheme getTheme() {
                return this.getThemeDef().getInitializedInstance();
            }

            public Map<ResourceLocation, ThemeDefinition<?>> getCustomThemes() {
                return this.themes;
            }

            public ResourceLocation getActiveTheme() {
                return this.activeTheme;
            }

            public void applyTheme(ResourceLocation id) {
                Map<ResourceLocation, ThemeDefinition<?>> allTheme = ThemeDefinition.getAll();
                this.activeTheme = allTheme.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<Color>,
            JsonDeserializer<Color> {
                public Color deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    Color color = new Color();
                    color.backgroundAlpha = json.has("backgroundAlpha") ? json.getAsJsonPrimitive("backgroundAlpha").getAsInt() : 204;
                    color.activeTheme = new ResourceLocation(json.getAsJsonPrimitive("activeTheme").getAsString());
                    json.getAsJsonArray("themes").forEach(e -> {
                        ThemeDefinition themeDef = (ThemeDefinition)context.deserialize(e, ThemeDefinition.class);
                        color.themes.put(themeDef.id, themeDef);
                    });
                    return color;
                }

                public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("backgroundAlpha", (Number)src.backgroundAlpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class Formatter
    implements IWailaConfig.Formatter {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "\u00a7f%s";
        private String fluidName = "\u00a7f%s";
        private String entityName = "\u00a7f%s";
        private String registryName = "\u00a78%s";

        public String getModName() {
            return this.modName;
        }

        public void setModName(String modName) {
            this.modName = modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public void setFluidName(String fluidName) {
            this.fluidName = fluidName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public Component modName(Object modName) {
            return Component.m_237113_((String)this.modName.formatted(modName));
        }

        @Override
        public Component blockName(Object blockName) {
            return Component.m_237113_((String)this.blockName.formatted(blockName));
        }

        @Override
        public Component fluidName(Object fluidName) {
            return Component.m_237113_((String)this.fluidName.formatted(fluidName));
        }

        @Override
        public Component entityName(Object entityName) {
            return Component.m_237113_((String)this.entityName.formatted(entityName));
        }

        @Override
        public Component registryName(Object registryName) {
            return Component.m_237113_((String)this.registryName.formatted(registryName));
        }
    }
}

