/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import mcp.mobius.waila.access.DataReader;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IEntityAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public enum ClientAccessor implements ICommonAccessor,
IBlockAccessor,
IEntityAccessor
{
    INSTANCE;

    private Level world;
    private Player player;
    private HitResult hitResult;
    private Vec3 renderingVec = null;
    private Block block = Blocks.f_50016_;
    private BlockState state = Blocks.f_50016_.m_49966_();
    private BlockPos pos = BlockPos.f_121853_;
    private ResourceLocation blockRegistryName = BuiltInRegistries.f_257033_.m_122315_();
    private BlockEntity blockEntity;
    private Entity entity;
    private long timeLastUpdate = System.currentTimeMillis();
    private ItemStack stack = ItemStack.f_41583_;
    private int updateId;
    private boolean dataAccess = true;
    private Vec3 rayCastOrigin;
    private Vec3 rayCastDirection;
    private double rayCastMaxDistance;
    private float frameTime;

    @Override
    public Level getWorld() {
        return this.world;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.state;
    }

    @Override
    public <T extends BlockEntity> T getBlockEntity() {
        return (T)this.blockEntity;
    }

    @Override
    public <T extends Entity> T getEntity() {
        return (T)this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    @Deprecated
    public HitResult getHitResult() {
        return this.getRawHitResult();
    }

    public HitResult getRawHitResult() {
        return this.hitResult;
    }

    @Override
    public BlockHitResult getBlockHitResult() {
        return (BlockHitResult)this.hitResult;
    }

    @Override
    public EntityHitResult getEntityHitResult() {
        return (EntityHitResult)this.hitResult;
    }

    @Override
    public Vec3 getRenderingPosition() {
        return this.renderingVec;
    }

    @Override
    public CompoundTag getServerData() {
        return this.getData().raw();
    }

    @Override
    public IDataReader getData() {
        if (!this.dataAccess) {
            return DataReader.NOOP;
        }
        DataReader data = DataReader.CLIENT;
        if (!this.isTagCorrectBlockEntity() && !this.isTagCorrectEntity()) {
            data.reset(null);
        }
        return data;
    }

    @Override
    public long getServerDataTime() {
        CompoundTag data = this.getData().raw();
        return data.m_128441_("WailaTime") ? data.m_128454_("WailaTime") : System.currentTimeMillis();
    }

    @Override
    public double getPartialFrame() {
        return this.frameTime;
    }

    @Override
    public Direction getSide() {
        return this.hitResult == null ? null : (this.hitResult.m_6662_() == HitResult.Type.ENTITY ? null : ((BlockHitResult)this.hitResult).m_82434_());
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public ResourceLocation getBlockId() {
        return this.blockRegistryName;
    }

    @Override
    public int getUpdateId() {
        return this.updateId;
    }

    @Override
    public Vec3 getRayCastOrigin() {
        return this.rayCastOrigin;
    }

    @Override
    public Vec3 getRayCastDirection() {
        return this.rayCastDirection;
    }

    @Override
    public double getRayCastMaxDistance() {
        return this.rayCastMaxDistance;
    }

    @Override
    public float getFrameTime() {
        return this.frameTime;
    }

    public void set(Level world, Player player, HitResult hit, Entity viewEntity, Vec3 rayCastOrigin, Vec3 rayCastDirection, double rayCastMaxDistance, float frameTime) {
        ++this.updateId;
        if (this.updateId == 0) {
            ++this.updateId;
        }
        this.world = world;
        this.player = player;
        this.hitResult = hit;
        this.rayCastMaxDistance = rayCastMaxDistance;
        this.rayCastOrigin = rayCastOrigin;
        this.rayCastDirection = rayCastDirection;
        this.frameTime = frameTime;
        if (this.hitResult.m_6662_() == HitResult.Type.BLOCK) {
            this.pos = ((BlockHitResult)hit).m_82425_();
            this.blockEntity = this.world.m_7702_(this.pos);
            this.entity = null;
            this.setState(world.m_8055_(this.pos));
        } else if (this.hitResult.m_6662_() == HitResult.Type.ENTITY) {
            this.entity = ((EntityHitResult)hit).m_82443_();
            this.pos = this.entity.m_20183_();
            this.blockEntity = null;
            this.setState(Blocks.f_50016_.m_49966_());
        }
        if (viewEntity != null) {
            double px = viewEntity.f_19854_ + (viewEntity.m_20185_() - viewEntity.f_19854_) * (double)frameTime;
            double py = viewEntity.f_19855_ + (viewEntity.m_20186_() - viewEntity.f_19855_) * (double)frameTime;
            double pz = viewEntity.f_19856_ + (viewEntity.m_20189_() - viewEntity.f_19856_) * (double)frameTime;
            this.renderingVec = new Vec3((double)this.pos.m_123341_() - px, (double)this.pos.m_123342_() - py, (double)this.pos.m_123343_() - pz);
        }
    }

    public void setState(BlockState state) {
        this.state = state;
        this.block = state.m_60734_();
        this.stack = this.block.m_7397_((BlockGetter)this.world, this.pos, state);
        this.blockRegistryName = BuiltInRegistries.f_256975_.m_7981_((Object)this.block);
    }

    public void setDataAccess(boolean dataAccess) {
        this.dataAccess = dataAccess;
    }

    private boolean isTagCorrectBlockEntity() {
        if (this.blockEntity == null) {
            return false;
        }
        CompoundTag tag = DataReader.CLIENT.raw();
        if (tag == null) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.m_128451_("x");
        int y = tag.m_128451_("y");
        int z = tag.m_128451_("z");
        BlockPos hitPos = ((BlockHitResult)this.hitResult).m_82425_();
        if (x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity() {
        if (this.entity == null) {
            return false;
        }
        CompoundTag tag = DataReader.CLIENT.raw();
        if (tag == null || !tag.m_128441_("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.m_128451_("WailaEntityID");
        if (id == this.entity.m_19879_()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }
}

