/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.config;

import cofh.core.common.config.IBaseConfig;
import cofh.lib.util.Constants;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class CoreClientConfig
implements IBaseConfig {
    public static Supplier<Boolean> enableEnchantmentDescriptions = Constants.TRUE;
    public static Supplier<Boolean> enableFoodDescriptions = Constants.TRUE;
    public static Supplier<Boolean> enableItemDescriptions = Constants.TRUE;
    public static Supplier<Boolean> enableItemTags = Constants.TRUE;
    public static Supplier<Boolean> enableKeywords = Constants.TRUE;
    public static Supplier<Boolean> alwaysShowDetails = Constants.FALSE;
    public static Supplier<Boolean> holdShiftForDetails = Constants.TRUE;
    public static Supplier<Boolean> particleDynamicLighting = Constants.TRUE;

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Tooltips");
        enableEnchantmentDescriptions = builder.comment("If TRUE, Enchantment descriptions will be added to the tooltip for Enchanted Books containing only a single enchantment.").define("Show Enchantment Descriptions", enableEnchantmentDescriptions);
        enableItemDescriptions = builder.comment("If TRUE, Item descriptions will be added to their tooltips if possible.").define("Show Item Descriptions", enableItemDescriptions);
        enableItemTags = builder.comment("If TRUE and Advanced Tooltips are enabled (F3+H), Tags will be will be added to item tooltips if possible.").define("Show Item Tags", enableItemTags);
        enableKeywords = builder.comment("If TRUE, Items will be associated with various keywords which assist with searching in various menus such as JEI.").define("Show Item Descriptions", enableKeywords);
        alwaysShowDetails = builder.comment("If TRUE, CoFH Items will always show full details (charge state, etc.) and will not require Shift to be held down.").define("Always Show Item Details", alwaysShowDetails);
        holdShiftForDetails = builder.comment("If TRUE, CoFH Items will display a message prompting to hold Shift to see full details (charge state, etc.). This does not change the behavior, only if the informational message should display.").define("Show 'Hold Shift for Details' Message", holdShiftForDetails);
        particleDynamicLighting = builder.comment("If TRUE, certain CoFH particles will dynamically emit light.").define("Dynamically Light Particles", particleDynamicLighting);
        builder.pop();
    }
}

