/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.AbstractContainerBlockEntity;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.container.BasicWorldlyContainer;
import dan200.computercraft.shared.media.items.PrintoutItem;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.peripheral.printer.PrinterMenu;
import dan200.computercraft.shared.peripheral.printer.PrinterPeripheral;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class PrinterBlockEntity
extends AbstractContainerBlockEntity
implements BasicWorldlyContainer {
    private static final String NBT_PRINTING = "Printing";
    private static final String NBT_PAGE_TITLE = "PageTitle";
    static final int SLOTS = 13;
    private static final int[] BOTTOM_SLOTS = new int[]{7, 8, 9, 10, 11, 12};
    private static final int[] TOP_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    private static final int[] SIDE_SLOTS = new int[]{0};
    private final PrinterPeripheral peripheral = new PrinterPeripheral(this);
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)13, (Object)ItemStack.f_41583_);
    private final NetworkedTerminal page = new NetworkedTerminal(25, 21, true);
    private String pageTitle = "";
    private boolean printing = false;

    public PrinterBlockEntity(BlockEntityType<PrinterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public IPeripheral peripheral() {
        return this.peripheral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            this.printing = nbt.m_128471_(NBT_PRINTING);
            this.pageTitle = nbt.m_128461_(NBT_PAGE_TITLE);
            this.page.readFromNBT(nbt);
        }
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_183515_(CompoundTag tag) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            tag.m_128379_(NBT_PRINTING, this.printing);
            tag.m_128359_(NBT_PAGE_TITLE, this.pageTitle);
            this.page.writeToNBT(tag);
        }
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        super.m_183515_(tag);
    }

    boolean isPrinting() {
        return this.printing;
    }

    @Override
    public NonNullList<ItemStack> getContents() {
        return this.inventory;
    }

    public void m_6596_() {
        super.m_6596_();
        this.updateBlockState();
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot == 0) {
            return PrinterBlockEntity.isInk(stack);
        }
        if (slot >= TOP_SLOTS[0] && slot <= TOP_SLOTS[TOP_SLOTS.length - 1]) {
            return PrinterBlockEntity.isPaper(stack);
        }
        return false;
    }

    public int[] m_7071_(Direction side) {
        return switch (side) {
            case Direction.DOWN -> BOTTOM_SLOTS;
            case Direction.UP -> TOP_SLOTS;
            default -> SIDE_SLOTS;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    NetworkedTerminal getCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing ? this.page : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNewPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (!this.canInputPage()) {
                return false;
            }
            if (this.printing && !this.outputPage()) {
                return false;
            }
            return this.inputPage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean endCurrentPage() {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            return this.printing && this.outputPage();
        }
    }

    int getInkLevel() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return PrinterBlockEntity.isInk(inkStack) ? inkStack.m_41613_() : 0;
    }

    int getPaperLevel() {
        int count = 0;
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (!PrinterBlockEntity.isPaper(paperStack)) continue;
            count += paperStack.m_41613_();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPageTitle(String title) {
        NetworkedTerminal networkedTerminal = this.page;
        synchronized (networkedTerminal) {
            if (this.printing) {
                this.pageTitle = title;
            }
        }
    }

    static boolean isInk(ItemStack stack) {
        return ColourUtils.getStackColour(stack) != null;
    }

    static boolean isPaper(ItemStack stack) {
        PrintoutItem printout;
        Item item = stack.m_41720_();
        return item == Items.f_42516_ || item instanceof PrintoutItem && (printout = (PrintoutItem)item).getType() == PrintoutItem.Type.PAGE;
    }

    private boolean canInputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        return !inkStack.m_41619_() && PrinterBlockEntity.isInk(inkStack) && this.getPaperLevel() > 0;
    }

    private boolean inputPage() {
        ItemStack inkStack = (ItemStack)this.inventory.get(0);
        DyeColor dye = ColourUtils.getStackColour(inkStack);
        if (dye == null) {
            return false;
        }
        for (int i = 1; i < 7; ++i) {
            ItemStack paperStack = (ItemStack)this.inventory.get(i);
            if (paperStack.m_41619_() || !PrinterBlockEntity.isPaper(paperStack)) continue;
            this.page.setTextColour(dye.m_41060_());
            this.page.clear();
            if (paperStack.m_41720_() instanceof PrintoutItem) {
                this.pageTitle = PrintoutItem.getTitle(paperStack);
                String[] text = PrintoutItem.getText(paperStack);
                String[] textColour = PrintoutItem.getColours(paperStack);
                for (int y = 0; y < this.page.getHeight(); ++y) {
                    this.page.setLine(y, text[y], textColour[y], "");
                }
            } else {
                this.pageTitle = "";
            }
            this.page.setCursorPos(0, 0);
            inkStack.m_41774_(1);
            if (inkStack.m_41619_()) {
                this.inventory.set(0, (Object)ItemStack.f_41583_);
            }
            paperStack.m_41774_(1);
            if (paperStack.m_41619_()) {
                this.inventory.set(i, (Object)ItemStack.f_41583_);
                this.updateBlockState();
            }
            this.m_6596_();
            this.printing = true;
            return true;
        }
        return false;
    }

    private boolean outputPage() {
        int height = this.page.getHeight();
        String[] lines = new String[height];
        String[] colours = new String[height];
        for (int i = 0; i < height; ++i) {
            lines[i] = this.page.getLine(i).toString();
            colours[i] = this.page.getTextColourLine(i).toString();
        }
        ItemStack stack = PrintoutItem.createSingleFromTitleAndText(this.pageTitle, lines, colours);
        for (int slot : BOTTOM_SLOTS) {
            if (!((ItemStack)this.inventory.get(slot)).m_41619_()) continue;
            this.inventory.set(slot, (Object)stack);
            this.updateBlockState();
            this.m_6596_();
            this.printing = false;
            return true;
        }
        return false;
    }

    private void updateBlockState() {
        ItemStack stack;
        int i;
        boolean top = false;
        boolean bottom = false;
        for (i = 1; i < 7; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.m_41619_() || !PrinterBlockEntity.isPaper(stack)) continue;
            top = true;
            break;
        }
        for (i = 7; i < 13; ++i) {
            stack = (ItemStack)this.inventory.get(i);
            if (stack.m_41619_() || !PrinterBlockEntity.isPaper(stack)) continue;
            bottom = true;
            break;
        }
        this.updateBlockState(top, bottom);
    }

    private void updateBlockState(boolean top, boolean bottom) {
        if (this.f_58859_ || this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)PrinterBlock.TOP) == top && (Boolean)state.m_61143_((Property)PrinterBlock.BOTTOM) == bottom) {
            return;
        }
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)PrinterBlock.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PrinterBlock.BOTTOM, (Comparable)Boolean.valueOf(bottom)));
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new PrinterMenu(id, inventory, this);
    }
}

