/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

public class BergamuteBlockEntity
extends SpecialFlowerBlockEntity {
    private static final int RANGE = 4;
    private static final Set<BergamuteBlockEntity> clientFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<BergamuteBlockEntity> serverFlowers = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public BergamuteBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.BERGAMUTE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.disabled = this.m_58904_().m_276867_(this.m_58899_());
        if (this.m_58904_().f_46443_) {
            clientFlowers.add(this);
        } else {
            serverFlowers.add(this);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.m_58904_().f_46443_) {
            clientFlowers.remove(this);
        } else {
            serverFlowers.remove(this);
        }
    }

    public static Pair<Integer, BergamuteBlockEntity> getBergamutesNearby(Level level, double x, double y, double z, int maxCount) {
        int count = 0;
        BergamuteBlockEntity tile = null;
        for (BergamuteBlockEntity f : level.f_46443_ ? clientFlowers : serverFlowers) {
            if (f.disabled || level != f.f_58857_ || !(f.getEffectivePos().m_203198_(x, y, z) <= 16.0)) continue;
            if (++count == 1) {
                tile = f;
            }
            if (count < maxCount) continue;
            break;
        }
        return Pair.of((Object)count, tile);
    }

    public static boolean isBergamuteNearby(Level level, double x, double y, double z) {
        return (Integer)BergamuteBlockEntity.getBergamutesNearby(level, x, y, z, 1).getFirst() > 0;
    }

    public static void particle(BergamuteBlockEntity berg) {
        int color = 50943;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
        berg.emitParticle(data, 0.3 + Math.random() * 0.5, 0.5 + Math.random() * 0.5, 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

