/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.otherside;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.world.DDPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OthersideBiomes {
    public static final ResourceKey<Biome> DEEPLANDS = OthersideBiomes.createKey("deeplands");
    public static final ResourceKey<Biome> ECHOING_FOREST = OthersideBiomes.createKey("echoing_forest");
    public static final ResourceKey<Biome> OVERCAST_COLUMNS = OthersideBiomes.createKey("overcast_columns");

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter worldCarvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(DEEPLANDS, (Object)OthersideBiomes.deeplands((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(ECHOING_FOREST, (Object)OthersideBiomes.echoingForest((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
        context.m_255272_(OVERCAST_COLUMNS, (Object)OthersideBiomes.overcastColumns((HolderGetter<PlacedFeature>)placedFeatures, worldCarvers));
    }

    public static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("deeperdarker", name));
    }

    private static Biome deeplands(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_CENTIPEDE.get(), 6, 1, 4));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 11, 3, 6));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20509_, 2, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_STONE_COLUMN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_GLEAM);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SURFACE_SCULK_STONE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_DECORATION);
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(-0.5f).m_47611_(-0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(1254763).m_48037_(1253458).m_48019_(1317939).m_48040_(OthersideBiomes.calculateSkyColor(-0.5f)).m_48027_(new AmbientMoodSettings((Holder)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getHolder().get(), 6000, 8, 2.0)).m_48021_(Musics.m_263184_((Holder)((Holder)DDSounds.MUSIC_BIOME_DEEPLANDS.getHolder().get()))).m_48018_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static Biome echoingForest(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobSpawnBuilder = new MobSpawnSettings.Builder();
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SCULK_SNAPPER.get(), 9, 1, 2));
        mobSpawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DDEntities.SHATTERED.get(), 17, 2, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.SCULK_GLEAM_FOREST);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.ECHO_TREE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.ECHO_SOIL);
        OthersideBiomes.addSculkDecoration(biomeBuilder);
        OthersideBiomes.addSculkOres(biomeBuilder);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.3f).m_47611_(0.5f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4330347).m_48037_(3742046).m_48019_(3152448).m_48040_(OthersideBiomes.calculateSkyColor(0.3f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.04f)).m_48027_(new AmbientMoodSettings((Holder)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getHolder().get(), 6000, 8, 2.0)).m_48021_(Musics.m_263184_((Holder)((Holder)DDSounds.MUSIC_BIOME_ECHOING_FOREST.getHolder().get()))).m_48018_()).m_47605_(mobSpawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    private static Biome overcastColumns(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, DDPlacedFeatures.GLOOMSLATE_COLUMN);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SURFACE_GLOOMSLATE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.GLOOMY_SCULK_VEGETATION);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMY_SCULK);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.MAGMA);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SOUL_SAND);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SOUL_SOIL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_COAL);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_IRON);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_COPPER);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_GOLD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_REDSTONE);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_EMERALD);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_LAPIS);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.GLOOMSLATE_DIAMOND);
        BiomeDefaultFeatures.m_126757_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.6f).m_47611_(0.2f).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4530962).m_48037_(3547929).m_48019_(4663576).m_48040_(OthersideBiomes.calculateSkyColor(0.6f)).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123762_, 0.026f)).m_48027_(new AmbientMoodSettings((Holder)DDSounds.AMBIENT_OTHERSIDE_ADDITIONS.getHolder().get(), 6000, 8, 2.0)).m_48021_(Musics.m_263184_((Holder)((Holder)DDSounds.MUSIC_BIOME_OVERCAST_COLUMNS.getHolder().get()))).m_48018_()).m_47605_(MobSpawnSettings.f_48326_).m_47601_(biomeBuilder.m_255380_()).m_47592_();
    }

    public static void addSculkDecoration(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_TENDRILS);
        builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, DDPlacedFeatures.SCULK_VINES);
    }

    public static void addSculkOres(BiomeGenerationSettings.Builder builder) {
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.INFESTED_SCULK);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_JAW);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_COAL);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_IRON);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_COPPER);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_GOLD);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_REDSTONE);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_EMERALD);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_LAPIS);
        builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, DDPlacedFeatures.SCULK_DIAMOND);
    }

    private static int calculateSkyColor(float temp) {
        float s = temp / 3.0f;
        s = Mth.m_14036_((float)s, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - s * 0.05f), (float)(0.5f + s * 0.1f), (float)1.0f);
    }
}

