/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.util;

import com.kyanite.deeperdarker.content.DDItems;
import java.util.EnumMap;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum DDArmorMaterials implements ArmorMaterial
{
    WARDEN("warden", 40, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), protectionValue -> {
        protectionValue.put(ArmorItem.Type.BOOTS, 4);
        protectionValue.put(ArmorItem.Type.LEGGINGS, 7);
        protectionValue.put(ArmorItem.Type.CHESTPLATE, 9);
        protectionValue.put(ArmorItem.Type.HELMET, 4);
    }), 18, SoundEvents.f_11679_, 4.0f, 0.1f, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DDItems.REINFORCED_ECHO_SHARD.get()}));

    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Ingredient repairIngredient;
    private static final EnumMap<ArmorItem.Type, Integer> DURABILITY_FOR_TYPE;

    private DDArmorMaterials(String name, int durability, EnumMap<ArmorItem.Type, Integer> protection, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Ingredient repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.protectionFunctionForType = protection;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    public int m_266425_(ArmorItem.Type type) {
        return DURABILITY_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient;
    }

    public String m_6082_() {
        return "deeperdarker:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        DURABILITY_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), durabilityValue -> {
            durabilityValue.put(ArmorItem.Type.BOOTS, 13);
            durabilityValue.put(ArmorItem.Type.LEGGINGS, 15);
            durabilityValue.put(ArmorItem.Type.CHESTPLATE, 16);
            durabilityValue.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

