/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class ItemBlockCable
extends BlockItem {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();

    public ItemBlockCable(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    protected boolean checkCableAt(Level world, BlockPos pos, @Nullable Direction side) {
        if (!CableHelpers.isNoFakeCable((BlockGetter)world, pos, side) && CableHelpers.getCable((BlockGetter)world, pos, side) != null) {
            return true;
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.canPlaceAt(world, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean m_40610_(BlockPlaceContext context, BlockState blockState) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        BlockPos target = pos.m_121945_(side);
        if (this.checkCableAt(world, pos, side)) {
            return true;
        }
        if (this.checkCableAt(world, target, side.m_122424_())) {
            return true;
        }
        return !this.m_6652_() || blockState.m_60710_((LevelReader)context.m_43725_(), target);
    }

    protected boolean attempItemUseTarget(UseOnContext context, BlockPos pos, Direction side, BlockCable blockCable, boolean offsetAdded) {
        BlockState blockState = context.m_43725_().m_8055_(pos);
        if (!context.m_43725_().m_46859_(pos)) {
            ICableFakeable cable = (ICableFakeable)CableHelpers.getCableFakeable((BlockGetter)context.m_43725_(), pos, side).orElse(null);
            if (cable != null && !cable.isRealCable()) {
                if (!context.m_43725_().m_5776_()) {
                    cable.setRealCable(true);
                    CableHelpers.updateConnections((BlockGetter)context.m_43725_(), pos, side);
                    CableHelpers.onCableAdded(context.m_43725_(), pos);
                    CableHelpers.onCableAddedByPlayer(context.m_43725_(), pos, (LivingEntity)context.m_43723_());
                }
                return true;
            }
            if (!offsetAdded) {
                for (IUseAction useAction : USE_ACTIONS) {
                    if (!useAction.attempItemUseTarget(context.m_43722_(), context.m_43725_(), pos, blockCable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void afterItemUse(UseOnContext context, BlockPos pos, BlockCable blockCable, boolean calledSuper) {
        if (!calledSuper) {
            ItemBlockCable.playPlaceSound(context.m_43725_(), pos);
            if (context.m_43722_().m_41720_() == RegistryEntries.ITEM_CABLE) {
                context.m_43722_().m_41774_(1);
            }
        }
        blockCable.setDisableCollisionBox(false);
    }

    public static void playPlaceSound(Level world, BlockPos pos) {
        BlockCable block = RegistryEntries.BLOCK_CABLE;
        SoundType soundType = block.m_49962_(block.m_49966_());
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f, false);
    }

    public static void playBreakSound(Level world, BlockPos pos, BlockState blockState) {
        world.m_6798_(2001, pos, Block.m_49956_((BlockState)blockState));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        BlockCable blockCable = (BlockCable)this.m_40614_();
        blockCable.setDisableCollisionBox(true);
        if (this.attempItemUseTarget(context, context.m_8083_(), context.m_43719_(), blockCable, false)) {
            this.afterItemUse(context, context.m_8083_(), blockCable, false);
            return InteractionResult.SUCCESS;
        }
        BlockPos posOffset = context.m_8083_().m_121945_(context.m_43719_());
        if (this.attempItemUseTarget(context, posOffset, context.m_43719_().m_122424_(), blockCable, true)) {
            this.afterItemUse(context, posOffset, blockCable, false);
            return InteractionResult.SUCCESS;
        }
        InteractionResult ret = super.m_6225_(context);
        this.afterItemUse(context, context.m_8083_(), blockCable, true);
        return ret;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemStack var1, Level var2, BlockPos var3, BlockCable var4);

        public boolean canPlaceAt(Level var1, BlockPos var2);
    }
}

