/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.ModRecipeProvider;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.TwoToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.tag.TagsHelper;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractRecipesDataProvider
extends ModRecipeProvider {
    protected static final TagKey<Item> TAG_INGOTS_STEEL = TagsHelper.ITEMS.createKey("forge:ingots/steel");
    protected static final TagKey<Item> TAG_INGOTS_URANIUM = TagsHelper.ITEMS.createKey("forge:ingots/uranium");
    protected static final Set<TagKey<Item>> TAGS_YELLORIUM_INGOTS = ImmutableSet.of(ContentTags.Items.INGOTS_YELLORIUM, TAG_INGOTS_URANIUM);
    private final String _modId;

    protected AbstractRecipesDataProvider(String modId, String name, PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super(name, output, registryLookup, modLocationRoot);
        this._modId = modId;
    }

    protected String group(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty");
        return this._modId + ":" + name;
    }

    protected ResourceLocationBuilder reactorRoot() {
        return this.root().appendPath(new String[]{"reactor"});
    }

    protected ResourceLocationBuilder reactorRoot(ReactorVariant variant) {
        return this.reactorRoot().appendPath(new String[]{variant.getName()});
    }

    protected ResourceLocationBuilder turbineRoot() {
        return this.root().appendPath(new String[]{"turbine"});
    }

    protected ResourceLocationBuilder turbineRoot(TurbineVariant variant) {
        return this.turbineRoot().appendPath(new String[]{variant.getName()});
    }

    protected ResourceLocationBuilder reprocessorRoot() {
        return this.root().appendPath(new String[]{"reprocessor"});
    }

    protected ResourceLocationBuilder fluidizerRoot() {
        return this.root().appendPath(new String[]{"fluidizer"});
    }

    protected ResourceLocationBuilder fluidizerSolidRoot() {
        return this.fluidizerRoot().appendPath(new String[]{"solid"});
    }

    protected ResourceLocationBuilder fluidizerSolidMixingRoot() {
        return this.fluidizerRoot().appendPath(new String[]{"solidmixing"});
    }

    protected ResourceLocationBuilder fluidizerFluidMixingRoot() {
        return this.fluidizerRoot().appendPath(new String[]{"fluidmixing"});
    }

    protected TwoToOneRecipeBuilder<ItemStack, FluidStack, ItemStack> reprocessor(IRecipeIngredient<ItemStack> ingot, IRecipeIngredient<FluidStack> fluid, IRecipeResult<ItemStack> result) {
        return new TwoToOneRecipeBuilder(ReprocessorRecipe.ID, ingot, fluid, result, ReprocessorRecipe.JSON_LABELS_SUPPLIER);
    }

    protected void chargingPort(Consumer<FinishedRecipe> builder, ResourceLocation name, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> powerTap, ItemLike item1, ItemLike item2) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('T'), powerTap.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126127_(Character.valueOf('1'), item1).m_126127_(Character.valueOf('2'), item2).m_126130_("212").m_126130_("GTG").m_126130_("212").m_126132_("has_item", (CriterionTriggerInstance)AbstractRecipesDataProvider.m_125977_((ItemLike)powerTap.get())).m_126140_(builder, name);
    }
}

