/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.setup.Config;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import terrails.xnetgases.Constants;
import terrails.xnetgases.helper.BaseChannelSettings;
import terrails.xnetgases.helper.ModuleEnums;
import terrails.xnetgases.module.chemical.ChemicalConnectorSettings;
import terrails.xnetgases.module.chemical.ChemicalEnums;
import terrails.xnetgases.module.chemical.utils.ChemicalHelper;

public class ChemicalChannelSettings
extends BaseChannelSettings {
    public static final String TAG_DELAY = "delay";
    public static final String TAG_DISTRIBUTE_OFFSET = "distribute_offset";
    public static final String TAG_DISTRIBUTE_INCREMENT = "distribute_increment";
    private ModuleEnums.ChannelMode channelMode = ModuleEnums.ChannelMode.DISTRIBUTE;
    private int delay = 0;
    private int roundRobinOffset = 0;
    private int roundRobinIncrement = 0;
    private List<Pair<SidedConsumer, ChemicalConnectorSettings>> extractors;
    private List<Pair<SidedConsumer, ChemicalConnectorSettings>> consumers;

    @Override
    public void readFromNBT(CompoundTag tag) {
        this.channelMode = ModuleEnums.ChannelMode.values()[tag.m_128445_("mode")];
        this.delay = tag.m_128451_(TAG_DELAY);
        this.roundRobinOffset = tag.m_128451_(TAG_DISTRIBUTE_OFFSET);
        this.roundRobinIncrement = tag.m_128451_(TAG_DISTRIBUTE_INCREMENT);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("mode", (byte)this.channelMode.ordinal());
        tag.m_128405_(TAG_DELAY, this.delay);
        tag.m_128405_(TAG_DISTRIBUTE_OFFSET, this.roundRobinOffset);
        tag.m_128405_(TAG_DISTRIBUTE_INCREMENT, this.roundRobinIncrement);
    }

    @Override
    public void readFromJson(JsonObject data) {
        this.channelMode = ModuleEnums.ChannelMode.byName(data.get("mode").getAsString());
        this.delay = data.get(TAG_DELAY).getAsInt();
        this.roundRobinOffset = data.get(TAG_DISTRIBUTE_OFFSET).getAsInt();
        this.roundRobinIncrement = data.get(TAG_DISTRIBUTE_INCREMENT).getAsInt();
    }

    @Override
    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        object.add("mode", (JsonElement)new JsonPrimitive(this.channelMode.name()));
        object.add(TAG_DELAY, (JsonElement)new JsonPrimitive((Number)this.delay));
        object.add(TAG_DISTRIBUTE_OFFSET, (JsonElement)new JsonPrimitive((Number)this.roundRobinOffset));
        object.add(TAG_DISTRIBUTE_INCREMENT, (JsonElement)new JsonPrimitive((Number)this.roundRobinIncrement));
        return object;
    }

    @Override
    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 10 == 0) {
            this.updateCache(channel, context);
            for (Pair<SidedConsumer, ChemicalConnectorSettings> entry : this.extractors) {
                BlockPos pos;
                SidedConsumer consumer = (SidedConsumer)entry.getFirst();
                ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)entry.getSecond());
                if (this.delay % settings.getOperationSpeed() != 0) continue;
                Level level = context.getControllerWorld();
                BlockPos extractorPos = context.findConsumerPosition(consumer.consumerId());
                if (extractorPos == null || !LevelTools.isLoaded((Level)level, (BlockPos)(pos = extractorPos.m_121945_(consumer.side())))) continue;
                BlockEntity be = level.m_7702_(pos);
                ChemicalEnums.Type type = settings.getConnectorType();
                Optional<IChemicalHandler<?, ?>> optional = ChemicalHelper.handler((ICapabilityProvider)be, settings.getFacing(), type);
                if (!optional.isPresent()) continue;
                IChemicalHandler<?, ?> handler = optional.get();
                if (this.checkRedstone(level, settings, extractorPos) || !context.matchColor(settings.getColorsMask())) {
                    return;
                }
                ChemicalStack<?> filter = settings.getMatcher();
                long toExtract = settings.getRate();
                long amount = ChemicalHelper.amountInTank(handler, settings.getFacing(), filter, type);
                if (amount <= 0L) continue;
                Integer count = settings.getMinMaxLimit();
                if (count != null) {
                    long canExtract = amount - (long)count.intValue();
                    if (canExtract <= 0L) continue;
                    toExtract = Math.min(toExtract, canExtract);
                }
                ArrayList<Pair<SidedConsumer, ChemicalConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, ChemicalConnectorSettings>>();
                ChemicalStack<?> extractStack = ChemicalHelper.extract(handler, toExtract, settings.getFacing(), Action.SIMULATE, settings.getConnectorType());
                if (extractStack.isEmpty() || filter != null && filter.getType() != extractStack.getType()) continue;
                toExtract = extractStack.getAmount();
                long remaining = this.insertSimulate(inserted, context, extractStack, settings.getConnectorType());
                if (inserted.isEmpty() || (toExtract -= remaining) <= 0L) continue;
                this.roundRobinOffset = (this.roundRobinOffset + this.roundRobinIncrement) % this.consumers.size();
                if (!context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) continue;
                ChemicalStack<?> stack = ChemicalHelper.extract(handler, toExtract, settings.getFacing(), Action.EXECUTE, settings.getConnectorType());
                if (stack.isEmpty()) {
                    throw new NullPointerException(handler.getClass().getName() + " misbehaved! handler.extract(" + toExtract + ", Action.SIMULATE, ConnectorType." + settings.getConnectorType().name() + ") returned null even though handler.extract(" + toExtract + ", Action.SIMULATE, ConnectorType." + settings.getConnectorType().name() + ") did not");
                }
                this.insertExecute(context, inserted, stack);
            }
        }
    }

    private long insertSimulate(List<Pair<SidedConsumer, ChemicalConnectorSettings>> inserted, IControllerContext context, ChemicalStack<?> stack, ChemicalEnums.Type type) {
        Level level = context.getControllerWorld();
        if (this.channelMode == ModuleEnums.ChannelMode.PRIORITY) {
            this.roundRobinOffset = 0;
        }
        this.roundRobinIncrement = 0;
        long amount = stack.getAmount();
        for (int j = 0; j < this.consumers.size(); ++j) {
            BlockPos consumerPos;
            int i = (j + this.roundRobinOffset) % this.consumers.size();
            if (this.roundRobinOffset < 0) continue;
            Pair<SidedConsumer, ChemicalConnectorSettings> entry = this.consumers.get(i);
            SidedConsumer consumer = (SidedConsumer)entry.getFirst();
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)entry.getSecond());
            if (settings.getConnectorType() != type) {
                ++this.roundRobinIncrement;
                continue;
            }
            if (settings.getMatcher() != null && settings.getMatcher().getType() != stack.getType() || (consumerPos = context.findConsumerPosition(consumer.consumerId())) == null) continue;
            if (!LevelTools.isLoaded((Level)level, (BlockPos)consumerPos) || this.checkRedstone(level, settings, consumerPos) || !context.matchColor(settings.getColorsMask())) {
                ++this.roundRobinIncrement;
                continue;
            }
            BlockPos pos = consumerPos.m_121945_(consumer.side());
            BlockEntity be = level.m_7702_(pos);
            Optional<IChemicalHandler<?, ?>> optional = ChemicalHelper.handler((ICapabilityProvider)be, settings.getFacing(), settings.getConnectorType());
            if (optional.isPresent()) {
                IChemicalHandler<?, ?> handler = optional.get();
                long toInsert = Math.min((long)settings.getRate(), amount);
                Integer count = settings.getMinMaxLimit();
                if (count != null) {
                    long a = ChemicalHelper.amountInTank(handler, settings.getFacing(), settings.getMatcher(), settings.getConnectorType());
                    long canInsert = (long)count.intValue() - a;
                    if (canInsert <= 0L) continue;
                    toInsert = Math.min(toInsert, canInsert);
                }
                if (settings.isTransferRateRequired() && (long)settings.getRate() > toInsert) continue;
                ChemicalStack copy = stack.copy();
                copy.setAmount(toInsert);
                ChemicalStack<?> remaining = ChemicalHelper.insert(handler, copy, settings.getFacing(), Action.SIMULATE, settings.getConnectorType());
                if (remaining.isEmpty() || !remaining.isEmpty() && copy.getAmount() != remaining.getAmount()) {
                    inserted.add(entry);
                    if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
                    return 0L;
                }
                if (!remaining.equals((Object)copy)) continue;
                ++this.roundRobinIncrement;
                continue;
            }
            ++this.roundRobinIncrement;
        }
        return amount;
    }

    private void insertExecute(IControllerContext context, List<Pair<SidedConsumer, ChemicalConnectorSettings>> inserted, ChemicalStack<?> stack) {
        long amount = stack.getAmount();
        for (Pair<SidedConsumer, ChemicalConnectorSettings> pair : inserted) {
            SidedConsumer consumer = (SidedConsumer)pair.getFirst();
            ChemicalConnectorSettings settings = (ChemicalConnectorSettings)((Object)pair.getSecond());
            BlockPos consumerPos = context.findConsumerPosition(consumer.consumerId());
            if (consumerPos == null) continue;
            BlockPos pos = consumerPos.m_121945_(consumer.side());
            BlockEntity be = context.getControllerWorld().m_7702_(pos);
            Optional<IChemicalHandler<?, ?>> optional = ChemicalHelper.handler((ICapabilityProvider)be, settings.getFacing(), settings.getConnectorType());
            if (!optional.isPresent()) continue;
            IChemicalHandler<?, ?> handler = optional.get();
            long toInsert = Math.min((long)settings.getRate(), amount);
            Integer count = settings.getMinMaxLimit();
            if (count != null) {
                long a = ChemicalHelper.amountInTank(handler, settings.getFacing(), settings.getMatcher(), settings.getConnectorType());
                long canInsert = (long)count.intValue() - a;
                if (canInsert <= 0L) continue;
                toInsert = Math.min(toInsert, canInsert);
            }
            ChemicalStack copy = stack.copy();
            copy.setAmount(toInsert);
            ChemicalStack<?> remaining = ChemicalHelper.insert(handler, copy, settings.getFacing(), Action.EXECUTE, settings.getConnectorType());
            if (!remaining.isEmpty() && (remaining.isEmpty() || copy.getAmount() == remaining.getAmount())) continue;
            this.roundRobinOffset = (this.roundRobinOffset + 1) % this.consumers.size();
            if ((amount -= copy.getAmount() - remaining.getAmount()) > 0L) continue;
            return;
        }
    }

    @Override
    public void cleanCache() {
        this.extractors = null;
        this.consumers = null;
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.extractors == null) {
            ChemicalConnectorSettings settings;
            SidedConsumer consumer;
            this.extractors = new ArrayList<Pair<SidedConsumer, ChemicalConnectorSettings>>();
            this.consumers = new ArrayList<Pair<SidedConsumer, ChemicalConnectorSettings>>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (ChemicalConnectorSettings)((Object)entry.getValue());
                if (settings.getConnectorMode() == ModuleEnums.ConnectorMode.EXT) {
                    this.extractors.add((Pair<SidedConsumer, ChemicalConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
                    continue;
                }
                this.consumers.add((Pair<SidedConsumer, ChemicalConnectorSettings>)Pair.of((Object)((SidedConsumer)entry.getKey()), (Object)((Object)settings)));
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry entry : connectors.entrySet()) {
                consumer = (SidedConsumer)entry.getKey();
                settings = (ChemicalConnectorSettings)((Object)entry.getValue());
                if (settings.getConnectorMode() != ModuleEnums.ConnectorMode.INS) continue;
                this.consumers.add((Pair<SidedConsumer, ChemicalConnectorSettings>)Pair.of((Object)consumer, (Object)((Object)settings)));
            }
            this.consumers.sort((o1, o2) -> Integer.compare(((ChemicalConnectorSettings)((Object)((Object)o2.getSecond()))).getPriority(), ((ChemicalConnectorSettings)((Object)((Object)o1.getSecond()))).getPriority()));
        }
    }

    @Override
    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 0, 90, 11, 10);
    }

    @Override
    public void createGui(IEditorGui gui) {
        gui.nl().choices("mode", "Distribution mode", (Enum)this.channelMode, (Enum[])ModuleEnums.ChannelMode.values());
    }

    @Override
    public void update(Map<String, Object> map) {
        this.channelMode = ModuleEnums.ChannelMode.valueOf(((String)map.get("mode")).toUpperCase(Locale.ROOT));
    }
}

