/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.data.PackOutput;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.data.LanguageProvider;

public class MDLangMerger
extends LanguageProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final PackOutput output;

    public MDLangMerger(PackOutput output) {
        super(output, "miners_delight", "en_us");
        this.output = output;
    }

    protected void addTranslations() {
        Path path = this.output.m_245114_().resolve("assets/miners_delight/lang/en_us.json");
        JsonObject original = null;
        try {
            original = this.collectExistingEntries(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addAll(this.fromResource("assets/miners_delight/lang/extra_lang.json").getAsJsonObject(), original);
    }

    private JsonObject collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonObject = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
            this.addAll(jsonObject, null);
            JsonObject jsonObject2 = jsonObject;
            return jsonObject2;
        }
    }

    private void addAll(JsonObject jsonObject, JsonObject compareAgainst) {
        jsonObject.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            String value = ((JsonElement)e.getValue()).getAsString();
            if (compareAgainst == null || !compareAgainst.has(key)) {
                this.add(key, value);
            }
        });
    }

    private JsonElement fromResource(String filepath) {
        JsonElement element = MDLangMerger.loadJsonResource(filepath);
        if (element == null) {
            throw new IllegalStateException(String.format("Could not find default lang file: %s", filepath));
        }
        return element;
    }

    public static JsonElement loadJsonResource(String filepath) {
        return MDLangMerger.loadJson(ClassLoader.getSystemResourceAsStream(filepath));
    }

    private static JsonElement loadJson(InputStream inputStream) {
        try {
            JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
            reader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)reader);
            reader.close();
            inputStream.close();
            return element;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

