/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.content.item;

import com.sammy.minersdelight.setup.MDItems;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.Nullable;

public class CopperCupItem
extends Item
implements DispensibleContainerItem {
    public static final Function<Item, ItemStack> BUCKET_TO_CUP = item -> {
        if (Items.f_42447_.equals(item)) {
            return MDItems.WATER_CUP.asStack();
        }
        if (Items.f_42455_.equals(item)) {
            return MDItems.MILK_CUP.asStack();
        }
        if (Items.f_151055_.equals(item)) {
            return MDItems.POWDERED_SNOW_CUP.asStack();
        }
        if (Items.f_42446_.equals(item)) {
            return MDItems.COPPER_CUP.asStack();
        }
        return ItemStack.f_41583_;
    };
    private final Fluid content;

    public CopperCupItem(Fluid pContent, Item.Properties pProperties) {
        super(pProperties);
        this.content = pContent;
    }

    public InteractionResult m_6880_(ItemStack pStack, Player pPlayer, LivingEntity pInteractionTarget, InteractionHand pUsedHand) {
        if (this.content.equals(Fluids.f_76191_)) {
            pPlayer.m_21008_(pUsedHand, Items.f_42446_.m_7968_());
            pInteractionTarget.m_6096_(pPlayer, pUsedHand);
            Item maybeFilledBucket = pPlayer.m_21120_(pUsedHand).m_41720_();
            ItemStack filledResult = ItemUtils.m_41813_((ItemStack)pStack, (Player)pPlayer, (ItemStack)BUCKET_TO_CUP.apply(maybeFilledBucket));
            pPlayer.m_21008_(pUsedHand, filledResult);
        }
        return super.m_6880_(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        BlockHitResult blockhitresult;
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        InteractionResultHolder ret = ForgeEventFactory.onBucketUse((Player)pPlayer, (Level)pLevel, (ItemStack)itemstack, (HitResult)(blockhitresult = CopperCupItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)(this.content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE))));
        if (ret != null) {
            return ret;
        }
        if (blockhitresult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (blockhitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.m_82425_();
        Direction direction = blockhitresult.m_82434_();
        BlockPos blockpos1 = blockpos.m_121945_(direction);
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.content == Fluids.f_76191_) {
                BucketPickup bucketpickup;
                ItemStack bucket;
                BlockState blockstate1 = pLevel.m_8055_(blockpos);
                Block block = blockstate1.m_60734_();
                if (block instanceof BucketPickup && !(bucket = (bucketpickup = (BucketPickup)block).m_142598_((LevelAccessor)pLevel, blockpos, blockstate1)).m_41619_()) {
                    ItemStack cup = BUCKET_TO_CUP.apply(bucket.m_41720_());
                    if (!cup.m_41619_()) {
                        pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        bucketpickup.getPickupSound(blockstate1).ifPresent(p_150709_ -> pPlayer.m_5496_(p_150709_, 1.0f, 1.0f));
                        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157816_, blockpos);
                        ItemStack itemstack2 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)cup);
                        if (!pLevel.f_46443_) {
                            CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)pPlayer, cup);
                        }
                        return InteractionResultHolder.m_19092_((Object)itemstack2, (boolean)pLevel.m_5776_());
                    }
                    pLevel.m_7731_(blockpos, blockstate1, 3);
                }
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            BlockState blockstate = pLevel.m_8055_(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(pLevel, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.m_142073_(pPlayer, pLevel, blockpos2, blockhitresult)) {
                this.m_142131_(pPlayer, pLevel, itemstack, blockpos2);
                if (pPlayer instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)pPlayer, blockpos2, itemstack);
                }
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)CopperCupItem.getEmptySuccessItem(itemstack, pPlayer), (boolean)pLevel.m_5776_());
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public static ItemStack getEmptySuccessItem(ItemStack pBucketStack, Player pPlayer) {
        return !pPlayer.m_150110_().f_35937_ ? new ItemStack((ItemLike)MDItems.COPPER_CUP.get()) : pBucketStack;
    }

    public void m_142131_(@Nullable Player pPlayer, Level pLevel, ItemStack pContainerStack, BlockPos pPos) {
    }

    public boolean m_142073_(@Nullable Player pPlayer, Level pLevel, BlockPos pPos, @Nullable BlockHitResult pResult) {
        boolean flag1;
        if (!(this.content instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = pLevel.m_8055_(pPos);
        Block block = blockstate.m_60734_();
        boolean flag = blockstate.m_60722_(this.content);
        boolean bl = flag1 = blockstate.m_60795_() || flag || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)pLevel, pPos, blockstate, this.content);
        if (!flag1) {
            return pResult != null && this.m_142073_(pPlayer, pLevel, pResult.m_82425_().m_121945_(pResult.m_82434_()), null);
        }
        if (pLevel.m_6042_().f_63857_() && this.content.m_205067_(FluidTags.f_13131_)) {
            int i = pPos.m_123341_();
            int j = pPos.m_123342_();
            int k = pPos.m_123343_();
            pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)pLevel, pPos, blockstate, this.content)) {
            ((LiquidBlockContainer)block).m_7361_((LevelAccessor)pLevel, pPos, blockstate, ((FlowingFluid)this.content).m_76068_(false));
            this.playEmptySound(pPlayer, (LevelAccessor)pLevel, pPos);
            return true;
        }
        if (!pLevel.f_46443_ && flag && !blockstate.m_278721_()) {
            pLevel.m_46961_(pPos, true);
        }
        if (!pLevel.m_7731_(pPos, this.content.m_76145_().m_76188_(), 11) && !blockstate.m_60819_().m_76170_()) {
            return false;
        }
        this.playEmptySound(pPlayer, (LevelAccessor)pLevel, pPos);
        return true;
    }

    protected void playEmptySound(@Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos) {
        SoundEvent soundevent = this.content.getFluidType().getSound(pPlayer, (BlockGetter)pLevel, pPos, SoundActions.BUCKET_EMPTY);
        if (soundevent == null) {
            soundevent = this.content.m_205067_(FluidTags.f_13132_) ? SoundEvents.f_11780_ : SoundEvents.f_11778_;
        }
        pLevel.m_5594_(pPlayer, pPos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157769_, pPos);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (((Object)((Object)this)).getClass() == CopperCupItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, this.content);
    }
}

