/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.event;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.chunk.IPlayerDataPlayer;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static ArrayDeque<ChunkInfo> delayedLoading = new ArrayDeque();
    public static Map<ChunkPos, ChunkInfo> delayedLoadingMap = new HashMap<ChunkPos, ChunkInfo>();
    static Map<ChunkPos, Integer> recentlyLoadedTimes = new HashMap<ChunkPos, Integer>();
    static Map<ChunkPos, Integer> recentlyUnLoadedTimes = new HashMap<ChunkPos, Integer>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long serverTime = event.getServer().m_129921_();
            int amount = 0;
            Iterator<ChunkInfo> iterator = delayedLoading.iterator();
            while (iterator.hasNext()) {
                ChunkInfo chunkInfo = iterator.next();
                if (serverTime - chunkInfo.originalTime > 20L && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_, chunkInfo.pos.f_45579_) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ + 1, chunkInfo.pos.f_45579_ + 1) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ + 1, chunkInfo.pos.f_45579_) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ + 1, chunkInfo.pos.f_45579_ - 1) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_, chunkInfo.pos.f_45579_ + 1) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_, chunkInfo.pos.f_45579_ - 1) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ - 1, chunkInfo.pos.f_45579_ + 1) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ - 1, chunkInfo.pos.f_45579_) && chunkInfo.level.m_7232_(chunkInfo.pos.f_45578_ - 1, chunkInfo.pos.f_45579_ - 1)) {
                    EventHandler.applyToChunk(chunkInfo);
                    delayedLoadingMap.remove(chunkInfo.pos);
                    iterator.remove();
                    if (++amount <= 20) continue;
                    return;
                }
                if (serverTime - chunkInfo.originalTime <= 1200L) break;
                if (BetterChunkLoading.IN_DEV && ((ServerLevel)chunkInfo.level).m_7726_().f_8327_.f_140761_.get(chunkInfo.pos.m_45588_()) == null) {
                    BetterChunkLoading.LOGGER.warn("Missing ticket!!!");
                    ((ServerLevel)chunkInfo.level).m_7726_().f_8327_.m_140805_(((ServerLevel)chunkInfo.level).m_7726_().f_8325_);
                    if (((ServerLevel)chunkInfo.level).m_7726_().f_8327_.f_140761_.get(chunkInfo.pos.m_45588_()) == null) {
                        BetterChunkLoading.LOGGER.warn("Really! Missing ticket!!! time since ticket:" + ((long)chunkInfo.level.m_7654_().m_129921_() - chunkInfo.originalTime));
                    }
                }
                EventHandler.applyToChunk(chunkInfo);
                iterator.remove();
                delayedLoadingMap.remove(chunkInfo.pos);
                if (++amount <= 20) continue;
                return;
            }
        }
    }

    private static void applyToChunk(ChunkInfo chunkInfo) {
        LevelChunk chunk = chunkInfo.level.m_6325_(chunkInfo.pos.f_45578_, chunkInfo.pos.f_45579_);
        for (int i = 0; i < chunkInfo.data.length; ++i) {
            if (chunkInfo.data[i] == null) continue;
            for (Short oshort : chunkInfo.data[i]) {
                BlockPos blockpos = ProtoChunk.m_63227_((short)oshort, (int)chunk.m_151568_(i), (ChunkPos)chunkInfo.pos);
                BlockState blockstate = chunk.m_8055_(blockpos);
                FluidState fluidstate = blockstate.m_60819_();
                if (!fluidstate.m_76178_()) {
                    fluidstate.m_76163_(chunkInfo.level, blockpos);
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) continue;
                BlockState blockstate1 = Block.m_49931_((BlockState)blockstate, (LevelAccessor)chunkInfo.level, (BlockPos)blockpos);
                chunkInfo.level.m_7731_(blockpos, blockstate1, 20);
            }
        }
        ((ServerChunkCache)chunkInfo.level.m_7726_()).f_8327_.m_140823_(BetterChunkLoading.TICKET_POST_PROCESS, chunkInfo.pos, ChunkLevel.m_287154_((FullChunkStatus)FullChunkStatus.FULL) - 1, (Object)chunkInfo.pos);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (!event.player.m_9236_().f_46443_ && event.player.f_19797_ % 3 == 0 && (player = event.player) instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            if (event.player.getClass() == ServerPlayer.class) {
                dataPlayer.betterchunkloading$getPlayerChunkData().onChunkChanged((ServerPlayer)event.player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player;
        if (!event.getEntity().m_9236_().f_46443_ && (player = event.getEntity()) instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            if (event.getEntity() instanceof ServerPlayer) {
                dataPlayer.betterchunkloading$getPlayerChunkData().onLogout((ServerPlayer)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        if (event.getLevel().m_5776_()) {
            return;
        }
        boolean sr = false;
        sr |= event.getLevel().m_7232_(event.getChunk().m_7697_().f_45578_ + 1, event.getChunk().m_7697_().f_45579_);
        sr |= event.getLevel().m_7232_(event.getChunk().m_7697_().f_45578_, event.getChunk().m_7697_().f_45579_ + 1);
        sr |= event.getLevel().m_7232_(event.getChunk().m_7697_().f_45578_ - 1, event.getChunk().m_7697_().f_45579_);
        if (!(sr |= event.getLevel().m_7232_(event.getChunk().m_7697_().f_45578_, event.getChunk().m_7697_().f_45579_ - 1))) {
            BetterChunkLoading.LOGGER.warn("no surrounding chunk!");
        }
        recentlyLoadedTimes.put(event.getChunk().m_7697_(), event.getLevel().m_7654_().m_129921_());
        if (recentlyUnLoadedTimes.containsKey(event.getChunk().m_7697_()) && event.getLevel().m_7654_().m_129921_() - recentlyUnLoadedTimes.get(event.getChunk().m_7697_()) < 100) {
            BetterChunkLoading.LOGGER.warn("Loaded shortly after unload:" + event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        if (event.getLevel().m_5776_()) {
            return;
        }
        recentlyUnLoadedTimes.put(event.getChunk().m_7697_(), event.getLevel().m_7654_().m_129921_());
        if (recentlyLoadedTimes.containsKey(event.getChunk().m_7697_()) && event.getLevel().m_7654_().m_129921_() - recentlyLoadedTimes.get(event.getChunk().m_7697_()) < 100) {
            BetterChunkLoading.LOGGER.warn("UnLoaded shortly after load:" + event.getChunk().m_7697_());
        }
    }

    public static class ChunkInfo {
        private final long originalTime;
        private final ChunkPos pos;
        private final Level level;
        private final ShortList[] data;

        public ChunkInfo(long originalTime, ChunkPos pos, Level level, ShortList[] data) {
            this.originalTime = originalTime;
            this.pos = pos;
            this.level = level;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkInfo chunkInfo = (ChunkInfo)o;
            return Objects.equals(this.pos, chunkInfo.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

