/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.chunk;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerChunkData {
    private static final ChunkPos INVALID = new ChunkPos(0, 0){

        public boolean equals(Object other) {
            return other == INVALID;
        }
    };
    private ChunkPos lastChunk = INVALID;
    private ResourceKey<Level> lastLevel = null;
    private Object2IntOpenHashMap<ChunkPos> lastTickets = new Object2IntOpenHashMap();
    private ChunkPos playerChunkLoadCenter = null;
    private ChunkPos playerChunkLoadLastPos = null;
    private int playerChunkLoadViewDistance = 0;
    private BlockPos[] playerMovementTracker = new BlockPos[6];
    private ChunkPos playerMovementTrackerAvg = INVALID;
    private int playerMovementTrackerIndex = 0;
    private long lastPlayerMovementUpdate = 0L;
    private BlockPos lastPlayerPos = null;
    private double playerMovementSpeed = 0.0;
    private Vec3 direction = Vec3.f_82478_;
    public boolean isFrozen = false;

    public void onChunkChanged(ServerPlayer player) {
        if (player == null || player.getClass() != ServerPlayer.class) {
            return;
        }
        if (!player.m_9236_().m_46472_().equals(this.lastLevel)) {
            this.lastLevel = player.m_9236_().m_46472_();
            this.setPlayerViewDistTo(null, player.m_9236_().m_7654_().m_129880_(this.lastLevel).m_7726_(), 0);
            this.playerChunkLoadViewDistance = 4;
            this.playerChunkLoadCenter = null;
            this.playerMovementTracker = new BlockPos[6];
            this.playerMovementTrackerAvg = INVALID;
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.lastChunk = null;
        }
        if (this.lastChunk != null && player.m_146902_().m_45594_(this.lastChunk) > 10) {
            this.setPlayerViewDistTo(player.m_146902_(), (ServerChunkCache)player.m_9236_().m_7726_(), 0);
            this.playerChunkLoadViewDistance = 4;
            this.playerChunkLoadCenter = null;
            this.playerMovementTracker = new BlockPos[6];
            this.playerMovementTrackerAvg = INVALID;
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
        }
        if (player.m_146902_().equals((Object)this.lastChunk)) {
            if (System.currentTimeMillis() - this.lastPlayerMovementUpdate > 5000L) {
                this.trackPlayerMovement(player);
            }
            if (this.isFrozen && player.m_9236_().m_7232_((int)((double)player.m_20183_().m_123341_() + this.direction.m_82541_().m_82542_((double)32.0, (double)32.0, (double)32.0).f_82479_) >> 4, (int)((double)player.m_20183_().m_123343_() + this.direction.m_82541_().m_82542_((double)32.0, (double)32.0, (double)32.0).f_82481_) >> 4)) {
                this.isFrozen = false;
            }
            return;
        }
        this.trackPlayerMovement(player);
        this.lastChunk = player.m_146902_();
    }

    private void trackPlayerMovement(ServerPlayer player) {
        int z;
        int x;
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos != null) {
            this.playerMovementSpeed -= this.playerMovementSpeed / 5.0;
            x = player.m_146903_() - this.lastPlayerPos.m_123341_();
            z = player.m_146907_() - this.lastPlayerPos.m_123343_();
            this.playerMovementSpeed += Math.sqrt(x * x + z * z) / ((double)(currentTime - this.lastPlayerMovementUpdate) / 1000.0) / 5.0;
        }
        this.lastPlayerPos = player.m_20183_();
        this.lastPlayerMovementUpdate = currentTime;
        if (!player.m_146902_().equals((Object)this.lastChunk)) {
            ChunkPos newPos;
            this.playerMovementTrackerIndex = (this.playerMovementTrackerIndex + 1) % this.playerMovementTracker.length;
            this.playerMovementTracker[this.playerMovementTrackerIndex] = player.m_20183_();
            x = 0;
            z = 0;
            int count = 0;
            for (int i = 0; i < this.playerMovementTracker.length; ++i) {
                BlockPos pos = this.playerMovementTracker[i];
                if (pos == null) continue;
                ++count;
                x += pos.m_123341_();
                z += pos.m_123343_();
            }
            this.playerMovementTrackerAvg = newPos = new ChunkPos(x / count >> 4, z / count >> 4);
            this.checkDirection(player);
        }
        this.chunkLoadForPlayer(player, this.playerMovementTrackerAvg);
    }

    private Vec3 calculatePlayerMovementVec(ServerPlayer player) {
        int xOld = 0;
        int zOld = 0;
        int oldCounter = 0;
        int xNew = 0;
        int zNew = 0;
        int newCounter = 0;
        for (int i = 0; i < this.playerMovementTracker.length; ++i) {
            BlockPos pos = this.playerMovementTracker[(this.playerMovementTrackerIndex + 1 + i) % this.playerMovementTracker.length];
            if (pos == null) continue;
            if (i < this.playerMovementTracker.length / 2) {
                xOld += pos.m_123341_();
                zOld += pos.m_123343_();
                ++oldCounter;
                continue;
            }
            xNew += pos.m_123341_();
            zNew += pos.m_123343_();
            ++newCounter;
        }
        if (oldCounter == 0 || newCounter == 0) {
            return new Vec3(48.0, 0.0, 0.0);
        }
        return new Vec3((double)((xNew /= newCounter) - (xOld /= oldCounter)), 0.0, (double)((zNew /= newCounter) - (zOld /= oldCounter)));
    }

    private void chunkLoadForPlayer(ServerPlayer player, ChunkPos newChunk) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        int viewDistance = this.calculateViewDistance(player);
        if (newChunk.equals((Object)this.playerChunkLoadCenter) && viewDistance == this.playerChunkLoadViewDistance) {
            return;
        }
        this.playerChunkLoadCenter = newChunk;
        this.setPlayerViewDistTo(this.playerChunkLoadCenter, ((ServerLevel)player.m_9236_()).m_7726_(), viewDistance);
    }

    private int calculateViewDistance(ServerPlayer player) {
        Vec3 playerMovement = this.calculatePlayerMovementVec(player).m_82542_(this.playerMovementSpeed / 4.3, 0.0, this.playerMovementSpeed / 4.3);
        ServerChunkCache chunkSource = ((ServerLevel)player.m_9236_()).m_7726_();
        int viewDistance = 4;
        if (playerMovement.m_82553_() < 120.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier) {
            viewDistance = playerMovement.m_82553_() <= 40.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier ? chunkSource.f_8325_.f_140126_ : (int)((1.0 - (playerMovement.m_82553_() - 40.0) / (80.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadModifier)) * (double)chunkSource.f_8325_.f_140126_);
        }
        return Math.max(5, viewDistance);
    }

    private void setPlayerViewDistTo(ChunkPos pos, ServerChunkCache chunkSource, int viewDistance) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        if (this.playerChunkLoadLastPos != null) {
            chunkSource.m_8438_(BetterChunkLoading.TICKET_PLAYER_CHUNK_AREA, this.playerChunkLoadLastPos, this.playerChunkLoadViewDistance, (Object)this.playerChunkLoadLastPos);
            this.playerChunkLoadLastPos = null;
        }
        if (pos == null) {
            return;
        }
        this.playerChunkLoadViewDistance = viewDistance;
        this.playerChunkLoadLastPos = pos;
        chunkSource.m_8387_(BetterChunkLoading.TICKET_PLAYER_CHUNK_AREA, pos, viewDistance, (Object)pos);
        chunkSource.m_8489_();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            BetterChunkLoading.LOGGER.info("Set player chunkloading chunk position to: " + pos + " size:" + viewDistance);
        }
    }

    public void onLogout(ServerPlayer player) {
        this.setPlayerViewDistTo(null, ((ServerLevel)player.m_9236_()).m_7726_(), 0);
    }

    private void checkDirection(ServerPlayer player) {
        this.direction = this.calculatePlayerMovementVec(player);
        Vec3 currentpos = player.m_20182_();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enablePrediction) {
            this.checkPrediction(this.direction, currentpos, player);
        }
        if (!player.m_9236_().m_7232_((int)((double)player.m_20183_().m_123341_() + this.direction.m_82541_().m_82542_((double)32.0, (double)32.0, (double)32.0).f_82479_) >> 4, (int)((double)player.m_20183_().m_123343_() + this.direction.m_82541_().m_82542_((double)32.0, (double)32.0, (double)32.0).f_82481_) >> 4)) {
            this.isFrozen = true;
        }
    }

    private void checkPrediction(Vec3 direction, Vec3 currentPos, ServerPlayer player) {
        int viewDist = ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading ? this.playerChunkLoadViewDistance : ((ServerChunkCache)player.m_9236_().m_7726_()).f_8325_.f_140126_;
        Vec3 predictedPos = currentPos.m_82549_(direction.m_82541_().m_82490_(16.0 * ((double)viewDist * 0.7)));
        for (int i = 0; i < 30 && !player.m_9236_().m_7232_((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4); ++i) {
            predictedPos = predictedPos.m_82549_(direction.m_82541_().m_82548_().m_82490_(16.0));
        }
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            ChunkPos nextPredictedStartChunk = new ChunkPos((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4);
            BetterChunkLoading.LOGGER.info("Set predictive loading position with area:" + Math.min(((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea, viewDist + 1) + " to chunk: " + nextPredictedStartChunk + " player chunk:" + player.m_146902_());
        }
        Object2IntOpenHashMap<ChunkPos> oldTickets = this.lastTickets;
        this.lastTickets = new Object2IntOpenHashMap();
        int repetition = (int)(Math.abs(direction.f_82479_) + Math.abs(direction.f_82481_)) / 16;
        for (int i = 0; i < repetition; ++i) {
            this.addpredictionChunkTicket(new ChunkPos((int)predictedPos.f_82479_ >> 4, (int)predictedPos.f_82481_ >> 4), Math.min(((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea, viewDist + 1), ((ServerLevel)player.m_9236_()).m_7726_());
            predictedPos = predictedPos.m_82549_(direction.m_82541_().m_82490_(16.0));
        }
        for (Object2IntMap.Entry ticketEntry : oldTickets.object2IntEntrySet()) {
            ((ServerChunkCache)player.m_9236_().m_7726_()).m_8438_(BetterChunkLoading.TICKET_PREDICTION, (ChunkPos)ticketEntry.getKey(), ticketEntry.getIntValue(), (Object)((ChunkPos)ticketEntry.getKey()));
        }
        ((ServerChunkCache)player.m_9236_().m_7726_()).m_8489_();
    }

    private void addpredictionChunkTicket(ChunkPos pos, int level, ServerChunkCache chunkSource) {
        chunkSource.m_8387_(BetterChunkLoading.TICKET_PREDICTION, pos, level, (Object)pos);
        this.lastTickets.put((Object)pos, level);
    }
}

