/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

public class LongEaser {
    boolean done = true;
    long target;
    long startValue;
    long value;
    double progress = 0.0;

    public LongEaser(long startValue) {
        this.target = this.value = startValue;
    }

    public long get() {
        return this.value;
    }

    public long getTarget() {
        return this.target;
    }

    public void forceFinish() {
        this.value = this.target;
        this.done = true;
        this.progress = 0.0;
    }

    public void set(long value) {
        if (this.target == value) {
            return;
        }
        this.target = value;
        this.startValue = this.value;
        this.progress = 0.0;
        this.done = false;
    }

    public void add(long value) {
        if (value == 0L) {
            return;
        }
        this.target += value;
        this.startValue = this.value;
        this.progress = 0.0;
        this.done = false;
    }

    public void tick(float partialTime) {
        if (this.done) {
            return;
        }
        if (this.progress >= 1.0) {
            this.done = true;
            this.value = this.target;
            return;
        }
        this.progress += (double)partialTime * 0.075;
        this.value = (long)((double)this.startValue + (double)(this.target - this.startValue) * this.ease(this.progress));
    }

    private double ease(double n) {
        double m = 1.0 - n;
        return n < 0.5 ? 2.0 * n * n : 1.0 - (-4.0 * (1.0 - m * m) + 4.0) * 0.5;
    }
}

