/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.networking.carbon;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.utils.config.config.ConfigHandler;

public class SaveConfigPacket
implements IPregenPacket {
    String identifier;
    String data;

    public SaveConfigPacket() {
    }

    public SaveConfigPacket(String identifier, String data) {
        this.identifier = identifier;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130072_(this.identifier, Short.MAX_VALUE);
        buffer.m_130072_(this.data, 262144);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
        this.data = buffer.m_130136_(262144);
    }

    @Override
    public void process(Player player) {
        if (!SaveConfigPacket.hasPermissions(player, 4)) {
            ChunkPregenerator.LOGGER.warn("Don't have Permission to Change configs");
            return;
        }
        ConfigHandler handler = ChunkPregenerator.FILE_WATCHER.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        try {
            ConfigHandler.load(handler, handler.getConfig(), (List<String>)ObjectArrayList.wrap((Object[])this.data.split("\n")), false);
            handler.save();
            ChunkPregenerator.LOGGER.info("Saved [" + this.identifier + "] Config");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean hasPermissions(Player player, int value) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_129792_() && server.m_7779_(player.m_36316_())) {
            return true;
        }
        return player.m_20310_(value);
    }
}

