/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.networking.carbon;

import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.config.config.ConfigHandler;
import pregenerator.common.utils.config.networking.carbon.ConfigAnswerPacket;
import pregenerator.common.utils.config.utils.MultilinePolicy;

public class ConfigRequestPacket
implements IPregenPacket {
    UUID id;
    String identifier;

    public ConfigRequestPacket() {
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.m_130072_(this.identifier, Short.MAX_VALUE);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.id = buffer.m_130259_();
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void process(Player player) {
        if (!ConfigRequestPacket.hasPermissions(player, 4)) {
            return;
        }
        ConfigHandler handler = ChunkPregenerator.FILE_WATCHER.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130072_(handler.getConfig().serialize(MultilinePolicy.DISABLED), 262144);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        NetworkManager.INSTANCE.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }

    private static boolean hasPermissions(Player player, int value) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_129792_() && server.m_7779_(player.m_36316_())) {
            return true;
        }
        return player.m_20310_(value);
    }
}

