/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import pregenerator.common.utils.config.api.IConfigSerializer;
import pregenerator.common.utils.config.api.buffer.IReadBuffer;
import pregenerator.common.utils.config.api.buffer.IWriteBuffer;
import pregenerator.common.utils.config.internal.DimensionSuggestion;
import pregenerator.common.utils.config.utils.Helpers;
import pregenerator.common.utils.config.utils.IEntryDataType;
import pregenerator.common.utils.config.utils.ParseResult;

public class SpeedEntry {
    ResourceKey<Level> dim;
    float speed;

    public SpeedEntry() {
        this((ResourceKey<Level>)Level.f_46428_, 1.0f);
    }

    public SpeedEntry(ResourceKey<Level> dim, float speed) {
        this.dim = dim;
        this.speed = speed;
    }

    public ResourceKey<Level> getDimension() {
        return this.dim;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpeedEntry) {
            SpeedEntry entry = (SpeedEntry)obj;
            return Float.compare(this.speed, entry.speed) == 0 && Objects.equals(this.dim, entry.dim);
        }
        return false;
    }

    public String[] serialize() {
        return new String[]{this.dim.m_135782_().toString(), Float.toString(this.speed)};
    }

    public static List<SpeedEntry> getDefaultValues() {
        ObjectArrayList list = new ObjectArrayList();
        list.add(new SpeedEntry((ResourceKey<Level>)Level.f_46428_, 1.0f));
        list.add(new SpeedEntry((ResourceKey<Level>)Level.f_46429_, 1.0f));
        list.add(new SpeedEntry((ResourceKey<Level>)Level.f_46430_, 1.0f));
        return list;
    }

    private static ParseResult<SpeedEntry> parse(String[] array) {
        if (array.length != 2) {
            return ParseResult.error(Helpers.mergeCompound(array), "Array Length isn't 2");
        }
        ResourceLocation location = ResourceLocation.m_135820_((String)array[0]);
        if (location == null) {
            return ParseResult.error(array[0], "First entry isn't in the ResourceLocation format");
        }
        ParseResult<Double> value = Helpers.parseDouble(array[1]);
        if (value.hasError()) {
            return value.onlyError();
        }
        return ParseResult.success(new SpeedEntry((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location), value.getValue().floatValue()));
    }

    private static void write(IWriteBuffer buffer, SpeedEntry entry) {
        buffer.writeString(entry.getDimension().m_135782_().toString());
        buffer.writeFloat(entry.getSpeed());
    }

    private static SpeedEntry read(IReadBuffer buffer) {
        return new SpeedEntry((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.m_135820_((String)buffer.readString())), buffer.readFloat());
    }

    public static IConfigSerializer<SpeedEntry> getSerializer() {
        IEntryDataType.CompoundDataType type = new IEntryDataType.CompoundDataType().withSuggestion("dimension", IEntryDataType.EntryDataType.STRING, DimensionSuggestion.INSTANCE).with("speed", IEntryDataType.EntryDataType.DOUBLE);
        return IConfigSerializer.withSync(type, new SpeedEntry(), SpeedEntry::parse, SpeedEntry::serialize, SpeedEntry::read, SpeedEntry::write);
    }
}

