/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import pregenerator.base.api.Align;
import pregenerator.common.utils.config.config.ConfigEntry;
import pregenerator.common.utils.config.config.ConfigSection;

public class PregenOverlay {
    ConfigEntry.BoolValue enabled;
    ConfigEntry.EnumValue<Align> HAlign;
    ConfigEntry.EnumValue<Align> VAlign;
    ConfigEntry.DoubleValue scale;
    ConfigEntry.IntValue pollDelay;

    public void init(ConfigSection section, boolean enabled, Align horizontal, Align vertical, double scale) {
        this.enabled = section.addBool("isEnabled", enabled, "Defines if the Overlay is enabled");
        this.HAlign = section.addEnum("Horizontal Alignment", horizontal, Align.class, "Defines the Horizontal Alignment of the Overlay");
        this.VAlign = section.addEnum("Vertical Alignment", vertical, Align.class, "Defines the Vertical Alignment of the Overlay");
        this.scale = section.addDouble("Scale", scale, "Defines the scale of the Overlay").setRange(0.1, 100.0);
        this.pollDelay = section.addInt("Poll Delay", 1, "Defines how many ticks between each poll are").setRange(1, 20);
    }

    public void setEnabled(boolean value) {
        this.enabled.set(value);
    }

    public void setPollRate(int value) {
        this.pollDelay.set(value);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Align vAlign() {
        return this.VAlign.get();
    }

    public Align hAlign() {
        return this.HAlign.get();
    }

    public double getScale() {
        return this.scale.get();
    }

    public int getPollDelay() {
        return Math.max(1, this.pollDelay.get());
    }
}

