/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import java.io.Reader;
import java.nio.file.Files;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.utils.config.api.IConfigSerializer;
import pregenerator.common.utils.config.api.ISuggestionProvider;
import pregenerator.common.utils.config.api.buffer.IReadBuffer;
import pregenerator.common.utils.config.api.buffer.IWriteBuffer;
import pregenerator.common.utils.config.utils.IEntryDataType;
import pregenerator.common.utils.config.utils.ParseResult;
import pregenerator.common.utils.misc.PregenAction;

public class PermissionRule {
    UUID player;
    EnumSet<PregenAction> actions;

    public PermissionRule() {
        this(UUID.fromString("84d6171c-8546-4309-bf3e-fc0956f32ea0"), EnumSet.of(PregenAction.ALL_DELETION, PregenAction.COMMANDS, PregenAction.ALL_SCANNING));
    }

    public PermissionRule(UUID player, EnumSet<PregenAction> actions) {
        this.player = player;
        this.actions = actions;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public EnumSet<PregenAction> getActions() {
        return this.actions;
    }

    public boolean hasAction(PregenAction action) {
        return this.actions.contains((Object)action);
    }

    public static ParseResult<PermissionRule> parse(String[] args) {
        UUID id = PermissionRule.parseUUID(args[0]);
        if (id == null) {
            return ParseResult.error(args[0], "[" + args[0] + "] isn't a UUID");
        }
        EnumSet<PregenAction> set = EnumSet.noneOf(PregenAction.class);
        PregenAction[] actions = PregenAction.values();
        for (int i = 0; i < actions.length && i + 1 < args.length; ++i) {
            if (!Boolean.valueOf(args[i + 1]).booleanValue()) continue;
            set.add(actions[i]);
        }
        return ParseResult.success(new PermissionRule(id, set));
    }

    public String[] serialize() {
        PregenAction[] actions = PregenAction.values();
        String[] result = new String[1 + actions.length];
        result[0] = this.player.toString();
        for (int i = 0; i < actions.length; ++i) {
            result[i + 1] = String.valueOf(this.actions.contains((Object)actions[i]));
        }
        return result;
    }

    public static PermissionRule read(IReadBuffer buffer) {
        UUID id = buffer.readUUID();
        EnumSet<PregenAction> set = EnumSet.noneOf(PregenAction.class);
        for (PregenAction action : PregenAction.values()) {
            if (!buffer.readBoolean()) continue;
            set.add(action);
        }
        return new PermissionRule(id, set);
    }

    public static void write(IWriteBuffer buffer, PermissionRule rules) {
        buffer.writeUUID(rules.player);
        for (PregenAction action : PregenAction.values()) {
            buffer.writeBoolean(rules.actions.contains((Object)action));
        }
    }

    public static UUID parseUUID(String arg) {
        try {
            return UUIDTypeAdapter.fromString((String)arg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IConfigSerializer<PermissionRule> createPermissions() {
        IEntryDataType.CompoundDataType type = new IEntryDataType.CompoundDataType().withSuggestion("PlayerId", IEntryDataType.EntryDataType.STRING, new PlayerSuggestions());
        for (PregenAction action : PregenAction.values()) {
            type.with(action.getName(), IEntryDataType.EntryDataType.BOOLEAN);
        }
        return IConfigSerializer.withSync(type, new PermissionRule(), PermissionRule::parse, PermissionRule::serialize, PermissionRule::read, PermissionRule::write);
    }

    public static class PlayerSuggestions
    implements ISuggestionProvider {
        @Override
        public void provideSuggestions(Consumer<ISuggestionProvider.Suggestion> output, Predicate<ISuggestionProvider.Suggestion> filter) {
            this.collectProfiles(T -> {
                ISuggestionProvider.Suggestion suggestion = ISuggestionProvider.Suggestion.namedValue(T.getName(), T.getId().toString());
                if (filter.test(suggestion)) {
                    output.accept(suggestion);
                }
            });
        }

        @OnlyIn(value=Dist.CLIENT)
        private void collectProfiles(Consumer<GameProfile> profile) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    profile.accept(player.m_36316_());
                }
            }
            try {
                JsonArray array = JsonParser.parseReader((Reader)Files.newBufferedReader(FMLPaths.GAMEDIR.get().resolve("usercache.json"))).getAsJsonArray();
                int m = array.size();
                for (int i = 0; i < m; ++i) {
                    JsonObject obj = array.get(i).getAsJsonObject();
                    String name = obj.get("name").getAsString();
                    UUID id = PermissionRule.parseUUID(obj.get("uuid").getAsString());
                    if (id == null || name == null) continue;
                    profile.accept(new GameProfile(id, name));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

