/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.impl.internal;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.SyncStatePacket;
import pregenerator.common.utils.config.api.IConfigChangeListener;
import pregenerator.common.utils.config.config.ConfigHandler;
import pregenerator.common.utils.config.gui.api.DataType;
import pregenerator.common.utils.config.gui.api.IModConfigs;
import pregenerator.common.utils.config.gui.api.ISuggestionRenderer;
import pregenerator.common.utils.config.gui.config.ColorElement;
import pregenerator.common.utils.config.gui.config.RegistryElement;
import pregenerator.common.utils.config.gui.screen.ConfigSelectorScreen;
import pregenerator.common.utils.config.gui.widgets.SuggestionRenderers;
import pregenerator.common.utils.config.impl.PerWorldProxy;
import pregenerator.common.utils.config.impl.entries.ColorValue;
import pregenerator.common.utils.config.impl.internal.ModConfigList;
import pregenerator.common.utils.config.impl.internal.ModConfigs;
import pregenerator.common.utils.config.networking.snyc.BulkSyncPacket;
import pregenerator.common.utils.config.networking.snyc.SyncPacket;
import pregenerator.common.utils.config.utils.SyncType;

public class EventHandler
implements IConfigChangeListener {
    public static final EventHandler INSTANCE = new EventHandler();
    Map<ModContainer, ModConfigs> configs = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap());

    @Override
    public void onConfigCreated(ConfigHandler config) {
        this.initMinecraftDataTypes(config);
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        ModLoadingContext context = ModLoadingContext.get();
        if ("minecraft".equals(context.getActiveNamespace())) {
            if (FMLEnvironment.production) {
                return;
            }
            throw new IllegalStateException("Mod Configs Must be created (not loaded) during a Mod Loading Phase");
        }
        this.configs.computeIfAbsent(context.getActiveContainer(), ModConfigs::new).addConfig(config);
    }

    public void initMinecraftDataTypes(ConfigHandler config) {
        config.addParser('C', ColorValue::parse);
        config.addTempParser('R');
        config.addTempParser('K');
    }

    @Override
    public void onConfigAdded(ConfigHandler config) {
    }

    @Override
    public void onConfigChanged(ConfigHandler config) {
        SyncPacket packet;
        if (FMLEnvironment.dist.isDedicatedServer()) {
            SyncPacket packet2 = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false);
            if (packet2 != null) {
                NetworkManager.INSTANCE.sendToAllPlayers(packet2);
            }
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (packet = SyncPacket.create(config, SyncType.SERVER_TO_CLIENT, false)) != null) {
            NetworkManager.INSTANCE.sendToAllPlayers(packet);
        }
        if (NetworkManager.INSTANCE.isInWorld() && (packet = SyncPacket.create(config, SyncType.CLIENT_TO_SERVER, false)) != null) {
            NetworkManager.INSTANCE.sendToServer(packet);
        }
    }

    @Override
    public void onConfigErrored(ConfigHandler configHandler) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processEvents();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onConfigsLoaded() {
        this.loadDefaultTypes();
        Object2ObjectLinkedOpenHashMap mappedConfigs = new Object2ObjectLinkedOpenHashMap();
        this.configs.forEach((arg_0, arg_1) -> EventHandler.lambda$onConfigsLoaded$1((Object2ObjectMap)mappedConfigs, arg_0, arg_1));
        mappedConfigs.forEach((M, C) -> M.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((U, S) -> this.create((Screen)S, ModConfigList.createMultiIfApplicable(M, C)))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void loadDefaultTypes() {
        ISuggestionRenderer.Registry.register(Item.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Block.class, new SuggestionRenderers.ItemEntry());
        ISuggestionRenderer.Registry.register(Fluid.class, new SuggestionRenderers.FluidEntry());
        ISuggestionRenderer.Registry.register(Enchantment.class, new SuggestionRenderers.EnchantmentEntry());
        ISuggestionRenderer.Registry.register(ColorValue.ColorWrapper.class, new SuggestionRenderers.ColorEntry());
        ISuggestionRenderer.Registry.register(MobEffect.class, new SuggestionRenderers.PotionEntry());
        DataType.registerType(Item.class, RegistryElement.createForType(Item.class, "minecraft:air"));
        DataType.registerType(Block.class, RegistryElement.createForType(Block.class, "minecraft:air"));
        DataType.registerType(Fluid.class, RegistryElement.createForType(Fluid.class, "minecraft:empty"));
        DataType.registerType(Enchantment.class, RegistryElement.createForType(Enchantment.class, "minecraft:fortune"));
        DataType.registerType(MobEffect.class, RegistryElement.createForType(MobEffect.class, "minecraft:luck"));
        DataType.registerType(ColorValue.ColorWrapper.class, new DataType(false, "0xFFFFFFFF", ColorElement::new, ColorElement::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Screen create(Screen screen, IModConfigs configs) {
        return new ConfigSelectorScreen(configs, screen);
    }

    public void onServerJoinPacket(Player player) {
        NetworkManager.INSTANCE.sendToPlayer(new SyncStatePacket(Dist.DEDICATED_SERVER), player);
        NetworkManager.INSTANCE.onPlayerJoined(player, true);
        BulkSyncPacket packet = BulkSyncPacket.create(ChunkPregenerator.FILE_WATCHER.getConfigsToSync(), SyncType.SERVER_TO_CLIENT, true);
        if (packet == null) {
            return;
        }
        NetworkManager.INSTANCE.sendToPlayer(packet, player);
    }

    @SubscribeEvent
    public void onServerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        NetworkManager.INSTANCE.onPlayerLeft(event.getEntity(), true);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerJoinEvent(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Minecraft.m_91087_().m_91089_() == null) {
            this.loadMPConfigs();
        }
        NetworkManager.INSTANCE.sendToServer(new SyncStatePacket(Dist.CLIENT));
        BulkSyncPacket packet = BulkSyncPacket.create(ChunkPregenerator.FILE_WATCHER.getConfigsToSync(), SyncType.CLIENT_TO_SERVER, true);
        if (packet == null) {
            return;
        }
        NetworkManager.INSTANCE.sendToServer(packet);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerServerLeaveEvent(ClientPlayerNetworkEvent.LoggingOut event) {
        NetworkManager.INSTANCE.onPlayerLeft((Player)event.getPlayer(), false);
        if (!Minecraft.m_91087_().m_91090_()) {
            for (ConfigHandler handler : ChunkPregenerator.FILE_WATCHER.getAllConfigs()) {
                if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
                handler.unload();
            }
        }
    }

    private void loadMPConfigs() {
        for (ConfigHandler handler : ChunkPregenerator.FILE_WATCHER.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    private void processEvents() {
        ChunkPregenerator.FILE_WATCHER.processFileSystemEvents();
    }

    private static /* synthetic */ void lambda$onConfigsLoaded$1(Object2ObjectMap mappedConfigs, ModContainer M, ModConfigs C) {
        if (M.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isPresent()) {
            return;
        }
        ((List)mappedConfigs.computeIfAbsent((Object)M, T -> new ObjectArrayList())).add(C);
    }
}

