/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config.gui.impl.carbon;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import pregenerator.common.utils.config.config.ConfigEntry;
import pregenerator.common.utils.config.config.ConfigSection;
import pregenerator.common.utils.config.gui.api.IConfigFolderNode;
import pregenerator.common.utils.config.gui.api.IConfigNode;
import pregenerator.common.utils.config.gui.impl.carbon.ConfigCompoundLeaf;
import pregenerator.common.utils.config.gui.impl.carbon.ConfigLeaf;

public class ConfigNode
implements IConfigFolderNode {
    ConfigSection section;
    List<IConfigNode> children;

    public ConfigNode(ConfigSection section) {
        this.section = section;
    }

    @Override
    public List<IConfigNode> getChildren() {
        if (this.children == null) {
            this.children = new ObjectArrayList();
            for (ConfigSection configSection : this.section.getChildren()) {
                this.children.add(new ConfigNode(configSection));
            }
            for (ConfigEntry configEntry : this.section.getEntries()) {
                if (!configEntry.isNotHidden()) continue;
                if (configEntry.getDataType().isCompound()) {
                    this.children.add(new ConfigCompoundLeaf(configEntry));
                    continue;
                }
                this.children.add(new ConfigLeaf(configEntry));
            }
        }
        return this.children;
    }

    @Override
    public String getNodeName() {
        return this.section.getName().toLowerCase(Locale.ROOT);
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel(this.section.getName());
    }

    @Override
    public Component getTooltip() {
        MutableComponent comp = Component.m_237119_();
        comp.m_7220_((Component)Component.m_237113_((String)this.section.getName()).m_130940_(ChatFormatting.YELLOW));
        String[] array = this.section.getComment();
        if (array != null && array.length > 0) {
            int i = 0;
            while (i < array.length) {
                comp.m_130946_("\n").m_130946_(array[i++]).m_130940_(ChatFormatting.GRAY);
            }
        }
        return comp;
    }
}

