/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.RetrogenScreen;
import pregenerator.common.generator.RetrogenManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class RetrogenPacket {

    public static class Sync
    implements IPregenPacket {
        ResourceLocation location;
        boolean enable;

        public Sync() {
        }

        public Sync(ResourceLocation location, boolean enable) {
            this.location = location;
            this.enable = enable;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.location);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.location = buffer.m_130281_();
            this.enable = buffer.readBoolean();
        }

        @Override
        public void process(Player player) {
            if (this.enable) {
                RetrogenManager.INSTANCE.enableFeature(this.location);
            } else {
                RetrogenManager.INSTANCE.disableFeature(this.location);
            }
        }
    }

    public static class Change
    implements IPregenPacket {
        ResourceLocation location;
        boolean enable;

        public Change() {
        }

        public Change(ResourceLocation location, boolean enable) {
            this.location = location;
            this.enable = enable;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.location);
            buffer.writeBoolean(this.enable);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.location = buffer.m_130281_();
            this.enable = buffer.readBoolean();
        }

        @Override
        public void process(Player player) {
            if (ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                if (this.enable) {
                    RetrogenManager.INSTANCE.enableFeature(this.location);
                } else {
                    RetrogenManager.INSTANCE.disableFeature(this.location);
                }
                NetworkManager.INSTANCE.sendToAllPlayers(new Sync(this.location, RetrogenManager.INSTANCE.isActive(this.location)));
                return;
            }
            player.m_5661_((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
            NetworkManager.INSTANCE.sendToPlayer(new Sync(this.location, RetrogenManager.INSTANCE.isActive(this.location)), player);
        }
    }

    public static class Answer
    implements IPregenPacket {
        Set<ResourceLocation> active = new ObjectLinkedOpenHashSet();
        Map<String, Map<String, List<ResourceLocation>>> mapped = new Object2ObjectLinkedOpenHashMap();

        public Answer() {
        }

        public Answer(Set<ResourceLocation> active, Map<String, Map<String, List<ResourceLocation>>> mapped) {
            this.active.addAll(active);
            this.mapped = mapped;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            IPregenPacket.writeCollectionReverse(buffer, this.active, FriendlyByteBuf::m_130085_);
            IPregenPacket.writeMap(buffer, this.mapped, FriendlyByteBuf::m_130070_, this::writeMapped);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.active, FriendlyByteBuf::m_130281_);
            IPregenPacket.readMap(buffer, this.mapped, FriendlyByteBuf::m_130277_, this::readMapped);
        }

        private Map<String, List<ResourceLocation>> readMapped(FriendlyByteBuf buffer) {
            Object2ObjectLinkedOpenHashMap map = new Object2ObjectLinkedOpenHashMap();
            IPregenPacket.readMap(buffer, map, FriendlyByteBuf::m_130277_, T -> {
                ObjectArrayList list = new ObjectArrayList();
                IPregenPacket.readCollection(buffer, list, FriendlyByteBuf::m_130281_);
                return list;
            });
            return map;
        }

        private void writeMapped(FriendlyByteBuf buffer, Map<String, List<ResourceLocation>> map) {
            IPregenPacket.writeMap(buffer, map, FriendlyByteBuf::m_130070_, (K, T) -> IPregenPacket.writeCollectionReverse(K, T, FriendlyByteBuf::m_130085_));
        }

        @Override
        public void process(Player player) {
            RetrogenManager.INSTANCE.onSyncPacket(this.active);
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof RetrogenScreen) {
                ((RetrogenScreen)screen).acceptMapped(this.mapped);
            }
        }
    }

    public static class Request
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            RetrogenManager instance = RetrogenManager.INSTANCE;
            NetworkManager.INSTANCE.sendToPlayer(new Answer(instance.getActiveFeatures(), instance.getAllMappedFeatures((RegistryAccess)ServerLifecycleHooks.getCurrentServer().m_206579_())), player);
        }
    }
}

