/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter.tasks;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.ChunkDeleter;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

public abstract class BaseDeletionTask
implements IDeletionTask {
    String name;
    ResourceKey<Level> type;
    UUID task = UUID.randomUUID();
    long activeTime = 0L;

    public BaseDeletionTask(CompoundTag nbt) {
        this(nbt.m_128461_("name"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim"))));
        if (nbt.m_128403_("taskId")) {
            this.task = nbt.m_128342_("taskId");
        }
        this.activeTime = nbt.m_128454_("active_time");
    }

    public BaseDeletionTask(String name, ResourceKey<Level> type) {
        this.name = name;
        this.type = type;
    }

    public abstract void append(MutableComponent var1);

    public abstract ChunkDeleter createTask(ServerLevel var1, IProcess.PrepareProgress var2);

    @Override
    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getTaskId() {
        return this.task;
    }

    @Override
    public Area getArea() {
        return new Area(this.getCenter(), this.getMaxRadius());
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.type;
    }

    @Override
    public void addActiveTime(long amount) {
        this.activeTime += amount;
    }

    @Override
    public long getActiveTime() {
        return this.activeTime;
    }

    @Override
    public MutableComponent getTaskDescription() {
        MutableComponent text = TextUtil.literal(this.name);
        ITask.insert("task.chunk_pregen.name", this.getName(), text, ChatFormatting.AQUA);
        ITask.insert("task.chunk_pregen.dimension", TextUtil.dimension(this.getDimension()), text, ChatFormatting.GREEN);
        this.append(text);
        ITask.removeLast(text.m_7360_());
        return TextUtil.translate("task.chunk_pregen.wrap", text);
    }

    @Override
    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("name", this.name);
        nbt.m_128359_("dim", this.type.m_135782_().toString());
        nbt.m_128362_("taskId", this.task);
        nbt.m_128356_("active_time", this.activeTime);
        return nbt;
    }

    @Override
    public CompletableFuture<ChunkDeleter> createTask(ServerLevel world, Executor exe, IProcess.PrepareProgress progress) {
        return CompletableFuture.supplyAsync(() -> this.createTask(world, progress), exe);
    }

    protected Path getSaveFile() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).getParent();
    }

    protected boolean isRegionFile(Path path) {
        return path.getFileName().toString().endsWith(".mca");
    }

    protected List<Path> getRegionFiles() {
        try {
            return ObjectIterators.pour(Files.newDirectoryStream(DimensionType.m_196975_(this.getDimension(), (Path)this.getSaveFile()).resolve("region"), this::isRegionFile).iterator());
        }
        catch (IOException e) {
            return ObjectLists.emptyList();
        }
    }
}

